// This is the file where all of the method, common to all pages are stored for javascript
//

function DisableAllButton()
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");				
	}catch(err){}
	if (getMXISession().IsPresent("StopBtnRestore") == false)
	{
		getMXISession().RemoveValue("JustNavigated");
		if (BackBtn().disabled == true)
		{
			getMXISession().SetValue("BackBtnState","true" );
		}
		else
		{
			getMXISession().SetValue("BackBtnState","false" );
		}

		if (NextBtn().disabled == true)
		{
			getMXISession().SetValue("NextBtnState","true" );
		}
		else
		{
			getMXISession().SetValue("NextBtnState","false" );
		}

		if (ExitBtn().disabled == true)
		{
			getMXISession().SetValue("ExitBtnState","true" );
		}
		else
		{
			getMXISession().SetValue("ExitBtnState","false" );
		}

		if (HelpBtn().disabled == true)
		{
			getMXISession().SetValue("HelpBtnState","true" );
		}
		else
		{
			getMXISession().SetValue("HelpBtnState","false" );
		}

		BackBtn().disabled = true;
		NextBtn().disabled = true;
		ExitBtn().disabled = true;
		HelpBtn().disabled = true;
		Refresh();
	}
}

function ReEnableButton()
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");				
	}catch(err){}
	if (getMXISession().IsPresent("StopBtnRestore") == false)
	{
		if ( !getMXISession().IsPresent("JustNavigated") )
		{
			if ("false" == getMXISession().GetValue("BackBtnState"))
			{
				BackBtn().disabled = false;
			}
			if ("false" == getMXISession().GetValue("NextBtnState"))
			{
				NextBtn().disabled = false;
			}
			if ("false" == getMXISession().GetValue("ExitBtnState"))
			{
				ExitBtn().disabled = false;
			}
			if ("false" == getMXISession().GetValue("HelpBtnState"))
			{
				HelpBtn().disabled = false;
			}
			Refresh();
		}
	}
	getMXISession().RemoveValue("JustNavigated");
}

//<!--##################################-->
function IsAuthAvailable(User)
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");				
	}catch(err){}
	var Result = true;
	if (isBioAvailable(User))
	{
		if (User.TwoFactor != 0)
		{
			if (!isPwdAvailable(User))
			{
				Result = false;
			}
		}
	}
	else
	{
		if (User.TwoFactor != 0)
		{
			Result = false;
		}
		else if (!isPwdAvailable(User))
		{
			Result = false;
		}
	}

	return Result;
}

function isBioAvailable(User)
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");				
	}catch(err){}
	var Result = true;
	if (User.EnrolledFingers == "" || User.EnrolledFingers == null)
	{
		Result = false;
	}
	else if (User.BiometricBlocked == 1)
	{
		Result = false;
	}
	return Result;
}

function isPwdAvailable(User)
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");				
	}catch(err){}
	var Result = true;
	var pwdState = User.PwdState();
	if (pwdState == SSD_PASSWORD_STATE_NOT_SET || pwdState == SSD_PASSWORD_STATE_BLOCKED)
	{
		Result = false;
	}
	return Result;
}

function IsObject( obj )
{
   return typeof( obj ) == 'object';
}
function IsNull( obj )
{
   return  ( obj == null );
}

function Refresh( )
{
	UpdateBrowserUI();
} 

function curWindow()
{
	var tmpWindow = window.top.middleFrame;
	if ( tmpWindow == null )
	{
		tmpWindow = window;
	}
	return tmpWindow;
}

function BackBtn()
{
	return window.top.buttonFrame.document.getElementById("BackBtn");
}

function NextBtn()
{
	return window.top.buttonFrame.document.getElementById("NextBtn");
}

function ExitBtn()
{
	return window.top.buttonFrame.document.getElementById("ExitBtn");
}

function HelpBtn()
{
	return window.top.buttonFrame.document.getElementById("HelpBtn");
}

function NavigateOnExit(NavigateTo, ExitingFrom, LogMsg, ShowLevel)
{
	if (LogMsg != "")
	{
		switch(ShowLevel)
		{
		case 0:
			ShowInfo(LogMsg);
			break;
		case 1:
			ShowWarning(LogMsg);
			break;
		case 2:
			ShowError(LogMsg);
			break;
		default:
			LogInfo(LogMsg);
			break;
		}
	}
	if (ExitingFrom != "")
	{
		LogExit(ExitingFrom)
	}
	if (NavigateTo != "")
	{
		Navigate(NavigateTo);
	}
	return;
}

//<!--##################################-->
var PollingTimer = 0;

function MXISDK_StateChanged()
{
	try
	{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");				
	}catch(err){}
	LogEntry("MXISDK_StateChanged");
	try
	{ 
		var CurrentState = getMXIDevice().State;
		var PreviousState = getMXISession().GetValue("DEVICE_SC");
		if (PreviousState == null || PreviousState == "" || CurrentState != PreviousState)
		{
			getMXISession().SetValue("DEVICE_SC", -1);
			var theState;
			StateChanged(theState);
			getMXISession().SetValue("DEVICE_SC", CurrentState);            
		}
	}catch(err){}
	LogExit("MXISDK_StateChanged");
}

//<!--##################################-->
function FindSpecificValueByName(ValueName)
{
	LogEntry("Common - Scripts - Common.js - FindSpecificValueByName");
	var Result = null;
	var CurValueName = "Blah";
	for (var num=1; (CurValueName != null && CurValueName != ""); num++)
	{	
		CurValueName = getMXISession().GetValue("Desc" + num);
		if (CurValueName != null && (CurValueName.length == ValueName.length) && CurValueName.indexOf(ValueName,1))
		{
			Result = getMXISession().GetValue("Value" + num);
			CurValueName = "";
		}
	}
	LogExit("Common - Scripts - Common.js - FindSpecificValueByName");
	return Result;
}

//<!--##################################-->
function RemoveValue(Desc)
{
	LogEntry("Common - Scripts - Common.js - RemoveValue");
	var CurValueName = 0;
	for (var num=1; CurValueName != null; num++)
	{
		var CurValueName = getMXISession().GetValue("Desc" + num);
		if (CurValueName != null && CurValueName == Desc)
		{
			DeleteQueryEntries(num);
			break;
		}
	}
	LogExit("Common - Scripts - Common.js - RemoveValue");
	return;
}

//<!--##################################-->
function DeleteQueryEntries(ItemNum)
{
	LogEntry("Common - Scripts - Common.js - DeleteQueryEntries");
	getMXISession().RemoveValue("Type" + ItemNum);
	getMXISession().RemoveValue("InfoDefault" + ItemNum);
	getMXISession().RemoveValue("Info" + ItemNum);
	getMXISession().RemoveValue("Width" + ItemNum);
	LogExit("Common - Scripts - Common.js - DeleteQueryEntries");
	return;
}

//<!--##################################-->
function GetUserAsSpecified(Operation, UserPrivilege, ListType, fIgnoreCurrent)
{
	LogEntry("Common - Scripts - Common.js - GetUserAsSpecified");
	var ArraySize = 0;
	var tmpArray = new Array(ArraySize);
	var UserList = GetUsers(UserPrivilege);
	if (Operation != "" && !fIgnoreCurrent)
	{
		if (GetCurUserPrivilegeLevel == SSD_USER_LEVEL_GENERAL && UserPrivilege != SSD_USER_LEVEL_ADMINISTRATOR)
		{
			UserList.length = 1;
			UserList[0] = getMXIDevice().CurrentUser;
		}
	}
	var i = 0;
	var User;
	switch(Operation)
	{
	case "Enroll Fingerprint":
		// Filter for user that has fingerprint left to Enroll
		while (UserList[i] != null)
		{
			User = getMXIDevice().User(UserList[i]);
  			var fingerList = User.EnrolledFingers;
  			var fingerCount;
  			if (fingerList == "")
  				fingerCount = 0;
  			else
  				fingerCount = fingerList.split(" ").length;
			
			if ((User.BioMaxAllowed - (fingerCount)) > 0)
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Authenticate Fingerprint":
		// Filter for user that already enrolled fingerprint
		while (UserList[i] != null)
		{
			User = getMXIDevice().User(UserList[i]);
			if (User.EnrolledFingers() != "" && User.BiometricBlocked == 0)
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Delete Fingerprint":
		// Filter for user that already enrolled fingerprint
		while (UserList[i] != null)
		{
			if (getMXIDevice().User(UserList[i]).EnrolledFingers != "")
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Authenticate Password":
		// Filter for user that already set a passwword
		while (UserList[i] != null)
		{
			if (getMXIDevice().User(UserList[i]).PwdState() == SSD_PASSWORD_STATE_OK)
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Change User Password":
		// Filter for user that already set a passwword (in any state but NOT_SET)
		while (UserList[i] != null)
		{
			if (getMXIDevice().User(UserList[i]).PwdState() != SSD_PASSWORD_STATE_NOT_SET)
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Unblock User Password":
		// Filter for user that already set a passwword (in any state but NOT_SET)
		while (UserList[i] != null)
		{
			if (getMXIDevice().User(UserList[i]).PwdState() == SSD_PASSWORD_STATE_BLOCKED)
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Unblock User Biometric":
		// Filter for user that already set a passwword (in any state but NOT_SET)
		while (UserList[i] != null)
		{
			if (getMXIDevice().User(UserList[i]).BiometricBlocked == SSD_BIOMETRIC_STATE_BLOCKED)
			{
				ArraySize++;
				tmpArray.length = ArraySize;
				tmpArray[ArraySize-1] = UserList[i];
			}
			i++;
		}
		break;
	case "Rescue User":
		// Filer for user that has key file under the current Administrator user
		var AdminUser = getMXIDevice().User(getMXIDevice().CurrentUser);
		if (AdminUser.privilege != SSD_USER_LEVEL_ADMINISTRATOR)
		{
			ShowWarning(GetErrorMsg(SSD_SCRIPT_WARN_ADMIN_REQUIRED, " (Rescue)"));
		}
		else
		{
			var oPrivateStore = AdminUser.Store;
			if (!oPrivateStore == null)
			{
				var FileList = oPrivateStore.ListFiles().split(SSD_LIST_SEPERATOR);
				if (!(FileList.length <= 0))
				{
					while (UserList[i] != null)
					{
						var slot = Base64.decode(getMXIDevice().User(UserList[i]).UID(SSD_UID_TYPE_SLOT));
						var szUserUniqueKey = "SSDAEK" + slot;
						var j = 0;
						while (FileList[j] != null)
						{
							if (FileList[j] == szUserUniqueKey)
							{
								ArraySize++;
								tmpArray.length = ArraySize;
								tmpArray[ArraySize-1] = UserList[i];
							}
							j++;
						}
					i++;
					}
				}
			}
		}
		break;
	default:
		// Do nothing here, return the whole user list, unmodified
		tmpArray.length = UserList.length;
		while (UserList[i] != null)
		{
			tmpArray[i] = UserList[i];
			i++;
		}
		break;
	}

	var finalArray = tmpArray;
	if (ListType == "display")
	{
		finalArray = FilterNameList(tmpArray);
	}
	LogExit("Common - Scripts - Common.js - GetUserAsSpecified");
	return finalArray;
}

//<!--##################################-->
function FilterNameList(NameList)
{
	LogEntry("Common - Scripts - Common.js - FilterNameList");
	var FilteredArray = NameList;
	var i = 0;
	while (FilteredArray[i] != null)
	{
		if (FilteredArray[i] == "_Admin")
		{
			FilteredArray[i] = "Administrator";
			i = FilteredArray.length - 1;
		}
		i++;
	}
	LogExit("Common - Scripts - Common.js - FilterNameList");
	return FilteredArray;
}

//<!--##################################-->
function GetUsers(UserPrivilege)
{
	LogEntry("Common - Scripts - Common.js - GetUsers");
	var ArraySize = 0;
	var tmpArray = new Array();
	var UserList = getMXIDevice().UserListAll();
	if (UserList != "")
		UserList = UserList.split(SSD_LIST_SEPERATOR);
	var numUser = 0;
	while (UserList.length > numUser)
	{
		if (UserPrivilege == SSD_USER_LEVEL_ALL || UserPrivilege == getMXIDevice().User(UserList[numUser]).Privilege)
		{
			ArraySize++;
			tmpArray.length = ArraySize;
			tmpArray[ArraySize-1] = UserList[numUser];
		}
		numUser++;
	}
	LogExit("Common - Scripts - Common.js - GetUsers");
	return tmpArray;
}

//<!--##################################-->
function SwitchStatusLight(color)
{
	LogEntry("Common - Scripts - Common.js - SwitchStatusLight");
	if (!isOn || lights != color)
	{
		StatusLight.src = GetBaseDirectory() + "Common/Images/" + color + "BrightLED.gif";
		isOn = true;
	}
	else
	{
		StatusLight.src = GetBaseDirectory() + "Common/Images/" + color + "OffLED.gif";
		isOn = false;
	}
	lights = color;
	LogExit("Common - Scripts - Common.js - SwitchStatusLight");
	return;
}

function GatherFrameInfo(UserInformationTable)
{
	LogEntry("Common - Scripts - Common.js - GatherFrameInfo");
	var FrameInfo;

	if (IsGecko())
	{
		var szData = getMXISession().GetValue("FrameInfo");
		szData = szData.replace(/\n/g, "");
		szData = szData.replace(/\r/g, "");
		szData = szData.replace(/\t/g, "");
		FrameInfo = szData.split(";");
	}
	else
	{
		FrameInfo = getMXISession().GetValue("FrameInfo").split(";");
	}

	getMXISession().RemoveValue("FrameInfo");
	if (FrameInfo[0] == "UsersInfo")
		GatherUsersInfo(UserInformationTable);
	else if (FrameInfo[0] == "DevInfo")
		GatherDevInfo(UserInformationTable);
	else if (FrameInfo[0] == "PartInfo")
		GatherPartInfo(UserInformationTable);
	else if (FrameInfo[0] == "VersionInfo")
		GatherVersionInfo(UserInformationTable);
	else if (FrameInfo[0] == "TokenObjects")
		GatherTokenObjects(UserInformationTable);
	else //Assuming Help page
	{
		// Add the trailing 'Empty' member
		FrameInfo.length++;
		var i = 0;
		var j = 0;
		while (FrameInfo.length > (i*2))
		{
			var newRow;
			var cell;
			var CellContent;
			
			if (FrameInfo[i*2] != " " && FrameInfo[i*2] != null && FrameInfo[i*2] != "")
			{
				newRow = UserInformationTable.insertRow(j);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.style.fontWeight = "bold";
				CellContent = RemoveLeadingSpaces(FrameInfo[i*2] + ": ");
				
				InnerText(cell, CellContent);
				j++;
			}

			if (FrameInfo[i * 2 + 1] != " " && FrameInfo[i * 2 + 1] != null && FrameInfo[i * 2 + 1] != "")
			{
				newRow = UserInformationTable.insertRow(j);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				CellContent = RemoveLeadingSpaces(FrameInfo[i * 2 + 1]);
				
				InnerText(cell, CellContent);
				j++;
			}
			newRow = UserInformationTable.insertRow(j);
			newRow.className = "Spacer";
			cell = newRow.insertCell(0);
			i++;
			j++;
		}
	}
	
	LogExit("Common - Scripts - Common.js - GatherFrameInfo");
	return;
}

//Removes the leading white spaces in a string
function RemoveLeadingSpaces(InString)
{
	var strResult = InString;
	while(strResult.length > 0 && strResult.indexOf(" ") == 0)
	{
		strResult = strResult.substring(1);
	}
	return strResult;
}

function GetProfileByID(ProfileType, ProfileID)
{
	LogEntry("Common - Scripts - Common.js - GetProfileByID");
	var vbListProfiles = new VBArray(getMXIEnt().DBProfiles.GetAllProfilesByDeviceType(ProfileType, getMXIDevice().Config.KindID));
	var listProfiles = vbListProfiles.toArray();
	for (var i=0; i < listProfiles.length && listProfiles[i].ID != ProfileID; i++);
	
	LogExit("Common - Scripts - Common.js - GetProfileByID");
	return listProfiles[i];
}

function GatherDevInfo(UserInformationTable)
{
	LogEntry("Common - Scripts - Common.js - GatherDevInfo");
	var row = 0;

	var DevType = FindSpecificValueByName("DeviceType");
	if (DevType == "Biometric")
	{
		var newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableHeader";
		var cell = newRow.insertCell(0);
		cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/DeviceInfo.gif' style='border:none;vertical-align:middle' />Biometric";
		cell.Height = "33px";
		cell.Width = "33px";
		cell.colSpan = "2";
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Biometric retry limit: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		if (getMXIDevice().Config.BiometricRetryLimit >= SSD_BYTE_INFINITE)
			InnerText(cell, "Infinite");
		else
			InnerText(cell, getMXIDevice().Config.BiometricRetryLimit + 1);
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Biometric failed attempts (device): ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().BiometricFailedAuthenticationCount);
		row++;

		newRow = UserInformation.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Biometric status: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		if (getMXIDevice().IsBiometricBlocked == SSD_BIOMETRIC_STATE_BLOCKED)
			InnerText(cell, "Blocked");
		else
			InnerText(cell, "Active");
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Biometric security level: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, GetBioSecValName(getMXIDevice().Config.BiometricSecurityLevel));
		row++;
  
		newRow = UserInformation.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		row++;
	}
  
	newRow = UserInformation.insertRow(row);
	newRow.className = "TableSpacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableHeader";
	cell = newRow.insertCell(0);
	cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/DeviceInfo.gif' style='border:none;vertical-align:middle' />Hardware";
	cell.Height = "33px";
	cell.Width = "33px";
	cell.colSpan = "2";
	row++;

	newRow = UserInformation.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	if (!IsToken())
	{
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Total disk space: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		if (IsClipDrive())
			InnerText(cell, getMXIDevice().Config.StorageSize + " MB");
		else
			InnerText(cell, getMXIDevice().Config.StorageSize + getMXIDevice().Config.ReadOnlySize + 10 + " MB");
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Public partition size: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().PartitionSize + " MB");
		row++;
	}

	newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableMessage";
	cell = newRow.insertCell(0);
	cell.className = "ContentTableLeftCol";
	InnerText(cell, "Public store size: ");
	cell = newRow.insertCell(1);
	cell.className = "ContentTableRightCol";
	InnerText(cell, getMXIDevice().Config.Capability(SSD_CAPABILITY_PUBLIC_STORE_SIZE_LIMIT) + " bytes");
	row++;

	newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableMessage";
	cell = newRow.insertCell(0);
	cell.className = "ContentTableLeftCol";
	InnerText(cell, "Private store size: ");
	cell = newRow.insertCell(1);
	cell.className = "ContentTableRightCol";
	InnerText(cell, getMXIDevice().Config.Capability(SSD_CAPABILITY_PRIVATE_STORE_SIZE_LIMIT) + " bytes");
	row++;

	newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableMessage";
	cell = newRow.insertCell(0);
	cell.className = "ContentTableLeftCol";
	InnerText(cell, "Device serial number: ");
	cell = newRow.insertCell(1);
	cell.className = "ContentTableRightCol";
	InnerText(cell, getMXIDevice().Config.SerialNumber);
	row++;

	newRow = UserInformation.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	if (!IsGecko())
	{
		try
		{
			var test = getMXIEnt().DBDevices;
			  
			newRow = UserInformation.insertRow(row);
			newRow.className = "TableSpacer";
			cell = newRow.insertCell(0);
			cell.className = "FirstOutputCol";
			cell = newRow.insertCell(1);
			cell.className = "SecondOutputCol";
			row++;

			newRow = UserInformationTable.insertRow(row);
			newRow.className = "ContentTableHeader";
			cell = newRow.insertCell(0);
			cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/DeviceInfo.gif' style='border:none;vertical-align:middle' />Profile";
			cell.Height = "33px";
			cell.Width = "33px";
			cell.colSpan = "2";
			row++;

			newRow = UserInformation.insertRow(row);
			newRow.className = "Spacer";
			cell = newRow.insertCell(0);
			cell.className = "FirstOutputCol";
			cell = newRow.insertCell(1);
			cell.className = "SecondOutputCol";
			row++;

			if (getMXIEnt().DBDevices.IsDeviceAlreadyRegistered(getMXIDevice().Config.SerialNumber))
			{
				var ListProfiles;

				var DeviceInfo = getMXIEnt().DBDevices.GetDeviceInformation(getMXIDevice().Config.SerialNumber);
				var ProfileName = "No Issuance profile found in the Database";
				var ProfileID = DeviceInfo.InitializationProfileID();
				if (ProfileID != null)
				{
					var Tmp = GetProfileByID(DB_PROFILE_TYPE_INITIALIZATION, ProfileID);
					if ( Tmp != null )
					{
						ProfileName = Tmp.Name;
					}
				}
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Initialization Profile: ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				InnerText(cell, ProfileName);
				row++;

				ProfileID = DeviceInfo.IssuanceProfileID();
				ProfileName = "No Issuance profile found in the Database";
				if (ProfileID != null)
				{
					var Tmp = GetProfileByID(DB_PROFILE_TYPE_ISSUANCE, ProfileID);
					if ( Tmp != null )
					{
						ProfileName = Tmp.Name;
					}
				}
				 			
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Usage Profile: ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				InnerText(cell, ProfileName);
				row++;
			}
			else
			{
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.style.fontStyle = "italic";
				cell.style.textalign = "center";
				cell.colSpan = "2";
				InnerText(cell, "This device was not yet initialized");
				row++;
			}
		}
		catch(err)
		{
			LogInfo(err.description);
		}
	}
	newRow = UserInformation.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	newRow = UserInformation.insertRow(row);
	newRow.className = "TableSpacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableHeader";
	newRow.id = "PasswordRules1";
	cell = newRow.insertCell(0);
	cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/DeviceInfo.gif' style='border:none;vertical-align:middle' />Password Policies";
	cell.Height = "33px";
	cell.Width = "33px";
	cell.colSpan = "2";
	row++;

	newRow = UserInformation.insertRow(row);
	newRow.className = "Spacer";
	newRow.id = "PasswordRules2";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	var finalize = true;
	var Config = getMXIDevice().Config;
	var i = 0;
	while (SSD_PWDRULE_NAME[i] != null)
	{
		try
		{
			var RuleVal = Config.PwdRule(i);
		}
		catch(err)
		{
			curWindow().document.getElementById("PasswordRules1").style.display = "none";
			curWindow().document.getElementById("PasswordRules2").style.display = "none";
			finalize = false;
			break;
		}
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, SSD_PWDRULE_NAME[i] + ": ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, RuleVal);
		if (RuleVal != "")
			if ((RuleVal == 0xFF && SSD_PWDRULE_NAME[i] == SSD_PWDRULE_NAME[0]) || (RuleVal == 0xFFFF && SSD_PWDRULE_NAME[i] == SSD_PWDRULE_NAME[9]))
				InnerText(cell, "Infinite");
		row++;
		i++;
	}

	if (finalize)
	{
		newRow = UserInformation.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		row++;
	}
	LogExit("Common - Scripts - Common.js - GatherDevInfo");
	return;
}

function GatherPartInfo(UserInformationTable)
{
	LogEntry("Common - Scripts - Common.js - GatherPartInfo");
	var row = 0;

	var newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableHeader";
	var cell = newRow.insertCell(0);
	cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/ViewPartition.gif' style='border:none;vertical-align:middle' />Private Partitions";
	cell.Height = "33px";
	cell.Width = "33px";
	cell.colSpan = "2";

	row++;
	newRow = UserInformationTable.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";

	if (getNumUser() >= 0)
	{
		if (!IsToken())
		{
			var UserList = GetUserAsSpecified("", SSD_USER_LEVEL_ALL, "exact", false);
			var UserListDisp = GetUserAsSpecified("", SSD_USER_LEVEL_ALL, "display", false);
			var i = 0;
			while (UserList[i] != null)
			{
				row++;
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, UserListDisp[i] + ": ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				var User = getMXIDevice().User(UserList[i]);
				InnerText(cell, User.PartitionSize + " MB");
				i++;
			}
		}
	}
	else
	{
		row++;
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		InnerText(cell, "No users are registered on the device");
		cell.style.fontStyle = "italic";
		cell.style.textalign = "center";
		cell.colSpan = "2";
	}

	row++;
	newRow = UserInformationTable.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";

	row++;
	newRow = UserInformationTable.insertRow(row);
	newRow.className = "TableSpacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";

	row++;
	newRow = UserInformationTable.insertRow(row);
	newRow.className = "ContentTableHeader";
	cell = newRow.insertCell(0);
	cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/ViewPartition.gif' style='border:none;vertical-align:middle' />Other Partitions";
	cell.Height = "33px";
	cell.Width = "33px";
	cell.colSpan = "2";

	row++;
	newRow = UserInformationTable.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";

	if (!IsToken())
	{
		row++;
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Public: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().PartitionSize + " MB");
	}

	if (!IsClipDrive())
	{
		row++;
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Read only: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().Config.ReadOnlySize + " MB");
	}

	if (!IsGecko())
	{
		row++;
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Available: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		var Size = getMXIDevice().AvailableSpace;
		InnerText(cell, Size + " MB");
	}
	
	row++;
	newRow = UserInformation.insertRow(row);
	newRow.className = "Spacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";

	LogExit("Common - Scripts - Common.js - GatherPartInfo");
	return;
}

function GatherVersionInfo(UserInformationTable)
{
	LogEntry("Common - Scripts - Common.js - GatherVersionInfo");
	var row = 0;
	var newRow;
	var cell;
	
	if ( getMXIDevice().State != SSD_DEVICE_STATE_REMOVED )
	{
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableHeader";
		cell = newRow.insertCell(0);
		cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/VersionInfo.gif' style='border:none;vertical-align:middle' />Hardware";
		cell.Height = "33px";
		cell.Width = "33px";
		cell.colSpan = "2";
		row++;

		newRow = UserInformation.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Model: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().Config.Kind);
		row++;

		if (!IsClipDrive())
		{
			newRow = UserInformationTable.insertRow(row);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Firmware: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			InnerText(cell, getMXIDevice().Config.Version(DEV_FIRMWARE));
			row++;

			newRow = UserInformationTable.insertRow(row);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Bootloader: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			InnerText(cell, getMXIDevice().Config.Version(DEV_BOOTLOADER));
			row++;
		}

		newRow = UserInformation.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		row++;
	}
	
	newRow = UserInformationTable.insertRow(row);
	newRow.className = "TableSpacer";
	cell = newRow.insertCell(0);
	cell.className = "FirstOutputCol";
	cell = newRow.insertCell(1);
	cell.className = "SecondOutputCol";
	row++;

	if (!IsGecko())
	{
		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableHeader";
		cell = newRow.insertCell(0);
		cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/VersionInfo.gif' style='border:none;vertical-align:middle' />Software";
		cell.Height = "33px";
		cell.Width = "33px";
		cell.colSpan = "2";
		row++;

		newRow = UserInformation.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Driver: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().Config.Version(DEV_DRIVER));
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Middleware: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, getMXIDevice().Config.Version(DEV_MIDDLEWARE));
		row++;

		newRow = UserInformationTable.insertRow(row);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, MXIDlgTitle + ": ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, "3.1.0.15");//getMXIDevice().Config.Version(DEV_PRESENTER));
		row++;

		newRow = UserInformation.insertRow(row);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
	}
	LogExit("Common - Scripts - Common.js - GatherVersionInfo");
	return;
}

function GatherTokenObjects(UserInformationTable)
{
	LogEntry("Common - Scripts - Common.js - GatherTokenObjects");
	var initSucceed = false;
	var row = 0;
	var newRow;
	var cell;
	var count;
	try
	{
		getMXIToken().InitTokenObjectList();
		initSucceed = true;
	}
	catch(err)
	{
		LogInfo(err.description);
	}
	if ( initSucceed )
	{
		count = getMXIToken().GetTokenObjectCount();
		if (count == 0)
		{
			newRow = UserInformationTable.insertRow(row);
			newRow.className = "ContentTableHeader";
			cell = newRow.insertCell(0);
			InnerText(cell, "No Token Objects Found");
			cell.Height = "33px";
			cell.Width = "33px";
			cell.colSpan = "2";

			row++;
			newRow = UserInformationTable.insertRow(row);
			newRow.className = "Spacer";
			cell = newRow.insertCell(0);
			cell.className = "FirstOutputCol";
			cell = newRow.insertCell(1);
			cell.className = "SecondOutputCol";
		}
		else
		{
			// List the objects
			var lastObject = false;
			var objType;
			var objAccess;
			var objContainer;
			var objId;
			var objLabel;
			while (lastObject == false)
			{
				objType      = getMXIToken().GetCurrentObjectType();
				objAccess    = getMXIToken().GetCurrentObjectAccess();
				objContainer = getMXIToken().GetCurrentObjectContainer();
				objId        = getMXIToken().GetCurrentObjectId();
				objLabel     = getMXIToken().GetCurrentObjectLabel();

				newRow = UserInformationTable.insertRow(row);
				newRow.className = "ContentTableHeader";
				cell = newRow.insertCell(0);
				InnerText(cell, objType);
				cell.Height = "33px";
				cell.Width = "33px";
				cell.colSpan = 2;

				row++;
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "Spacer";
				cell = newRow.insertCell(0);
				cell.className = "FirstInputColToken";
				cell = newRow.insertCell(1);
				cell.className = "SecondInputColToken";

				row++;
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Access type: ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				InnerText(cell, objAccess);

				row++;
				newRow = UserInformationTable.insertRow(row);
				newRow.className = "Spacer";
				cell = newRow.insertCell(0);
				cell.className = "FirstInputColToken";
				cell = newRow.insertCell(1);
				cell.className = "SecondInputColToken";

				if (objLabel != "")
				{
					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "Label: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, objLabel);

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "Spacer";
					cell = newRow.insertCell(0);
					cell.className = "FirstInputColToken";
					cell = newRow.insertCell(1);
					cell.className = "SecondInputColToken";
				}

				if (objContainer != "")
				{
					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "CSP container: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, objContainer);

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "Spacer";
					cell = newRow.insertCell(0);
					cell.className = "FirstInputColToken";
					cell = newRow.insertCell(1);
					cell.className = "SecondInputColToken";
				}

				if (objId != "")
				{
					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "Object ID: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, objId);

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "Spacer";
					cell = newRow.insertCell(0);
					cell.className = "FirstInputColToken";
					cell = newRow.insertCell(1);
					cell.className = "SecondInputColToken";
				}

				// Now, based on object type, print out the object information
				if (objType == "Data Object")
				{
				}

				if (objType == "Certificate")
				{
					var certType;
					certType = getMXIToken().GetCurrentCertType();

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "Certificate type: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, certType);

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "Spacer";
					cell = newRow.insertCell(0);
					cell.className = "FirstInputColToken";
					cell = newRow.insertCell(1);
					cell.className = "SecondInputColToken";
				}
				if (objType == "Public Key" || objType == "Private Key" || objType == "Secret Key")
				{
					var keyType;
					var keyUsage;
					var keySize;
					keyType  = getMXIToken().GetCurrentObjectKeyType();
					keyUsage = getMXIToken().GetCurrentObjectUsage();
					keySize  = getMXIToken().GetCurrentObjectKeySize();

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "Key type: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, keyType);

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "Spacer";
					cell = newRow.insertCell(0);
					cell.className = "FirstInputColToken";
					cell = newRow.insertCell(1);
					cell.className = "SecondInputColToken";

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "Key usage: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, keyUsage);

					row++;
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "Spacer";
					cell = newRow.insertCell(0);
					cell.className = "FirstInputColToken";
					cell = newRow.insertCell(1);
					cell.className = "SecondInputColToken";
					if (keySize != "Unknown")
					{
						row++;
						newRow = UserInformationTable.insertRow(row);
						newRow.className = "ContentTableMessage";
						cell = newRow.insertCell(0);
						cell.className = "ContentTableLeftCol";
						InnerText(cell, "Key size: ");
						cell = newRow.insertCell(1);
						cell.className = "ContentTableRightCol";
						InnerText(cell, keySize);

						row++;
						newRow = UserInformationTable.insertRow(row);
						newRow.className = "Spacer";
						cell = newRow.insertCell(0);
						cell.className = "FirstInputColToken";
						cell = newRow.insertCell(1);
						cell.className = "SecondInputColToken";
					}
				}

				row++;
				lastObject = getMXIToken().NextTokenObject();
			}
		}
	}
	LogExit("Common - Scripts - Common.js - GatherTokenObjects");
	return;
}


var CertViewList = new Array(); //Holds a list of object handles corresponding to certificate objects being displayed
var CertDelList  = new Array(); //Holds a list of object handles corresponding to certificate objects to be deleted

//POST Current row is highlighted unless a certificate is already being displayed
function highlightOn(ev)
{
   if (getMXIToken().IsCertOpened() == 1) return;
   if (ev.srcElement)
   {
      var node3 = ev.srcElement.parentNode.parentNode; //row
      node3.className = "CertLinkOn";                   
   }
   return;
}

//POST Current row is un-highlighted unless a certificate is already being displayed
function highlightOff(ev)
{
   if (getMXIToken().IsCertOpened() == 1) return;
   if (ev.srcElement)
   {
      var node3 = ev.srcElement.parentNode.parentNode; //row
      node3.className = "CertLinkOff";                   
   }
   return;
}

//POST: Certificate is marked/unmarked for deletion according to checkbox
function markCert(ev)
{
   if (ev.srcElement)
   {
      var node1 = ev.srcElement;
      var node3 = ev.srcElement.parentNode.parentNode; //row
      
      var rowIndex = node3.rowIndex;
      if (node1.checked)
      {
         CertDelList[rowIndex-1] = CertViewList[rowIndex-1]; 
      }
      else
      {
         CertDelList[rowIndex-1] = 0; // 0-handle is ignored
      }
   }
   
   CheckNextBtnState();
   
   return;
}

function areAnyCertsSelected( )
{
   var ret;
   if (CertDelList.length == 0)
   {
      ret = false;
   }
   else
   {
      var iter;
      ret = false;
      for (iter = 0; iter < CertDelList.length; iter++)
      {
         if (CertDelList[iter] != 0) 
         {
            ret = true;
            break;
         }
      }
   }
   return ret;
}
//POST: Certificate details are displayed using Windows Certificate Viewer.
//POST: Only one certificate is displayed at a time.
function viewCert(ev)
{
   if (ev.srcElement)
   {
      var node3 = ev.srcElement.parentNode.parentNode; //row
      var rowIndex = node3.rowIndex;
      getMXIToken().OpenCert(CertViewList[rowIndex-1]); 
   }
   return;
}

//POST: All certificates specified in CertDelList are deleted from the device.
//POST: Corresponding public/private keys are deleted as well.
//POST: Corresponding data objects are deleted iff no longer associated with any certificate.
function deleteCert(UserInformation,CertViewList,CertDelList)
{
   //Delete certificate handles from both lists
	while (CertDelList.length > 0)
	{
	   //Find any matching handles
	   var found = false;
   	for (i = 0; (i < CertDelList.length) && (!found); i++)
	   {
	      if (CertDelList[i] == 0) continue; //Ignode 0-handle entry
      	for (j = 0; (j < CertViewList.length) && (!found); j++)
	      {
   	      if (CertViewList[j] == 0) continue; //Ignode 0-handle entry
	         if (CertDelList[i] == CertViewList[j])
   	      {
               var delCount = getMXIToken().DeleteCert(CertDelList[i]);
               if (delCount > 0)
               {
                  document.getElementById('UserInformation').deleteRow(j+1);
                  CertViewList.splice(j,1);
                  CertDelList.splice(i,1);
                  found = true;
               }
            }
         }
      }
      if (!found) break; //No match found
   }
   
   //Indicate no certificate found 
   if (CertViewList.length == 0)
   {
   	var newRow;
   	var cell;
               document.getElementById('UserInformation').deleteRow(0);
      newRow = document.getElementById('UserInformation').insertRow(0);
		newRow.className = "CertTableHeader";
		cell = newRow.insertCell(0);
		cell.innerText = "No Certificates Found";
		cell.Height = "33px";
		cell.Width = "33px";
		cell.colSpan = "6";
   }
   return;
}

//POST: All objects are retrieved from the device.
//POST: A list of all certificates currently on the device is displayed.
function GatherTokenCertObjects(UserInformationTable)
{
	LogEntry("Common - Scripts - Common.js - GatherTokenCertObjects");
	var initSucceed = false;
	var row = 0;
	var newRow;
	var cell;
	var count;
	try
	{
		getMXIToken().InitTokenObjectList();
		initSucceed = true;
	}
	catch (err)
	{
		LogInfo(err.description);
	}
	if (initSucceed)
	{
		count = getMXIToken().GetCertCount();
		if (count == 0)
		{
			newRow = UserInformationTable.insertRow(row);
			newRow.className = "CertTableHeader";
			cell = newRow.insertCell(0);
			InnerText(cell, "There are no certificate on this device");
			cell.Height = "33px";
			cell.Width = "33px";
			cell.colSpan = "6";
			row++;

			newRow = UserInformationTable.insertRow(row);
			newRow.className = "Spacer";
			cell = newRow.insertCell(0);
			cell.className = "FirstOutputCol";
			cell = newRow.insertCell(1);
			cell.className = "SecondOutputCol";
			row++;

			newRow = UserInformationTable.insertRow(row);
			newRow.className = "Spacer";
			cell = newRow.insertCell(0);
			cell.className = "FirstOutputCol";
			cell = newRow.insertCell(1);
			cell.className = "SecondOutputCol";
			row++;
		}
		else
		{
         var col = 0;
			newRow = UserInformationTable.insertRow(row);
	   	newRow.className = "CertTableHeader";

         //Checkbox column
			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";

			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";
			cell.innerText = "Issued By";

			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";
			cell.innerText = "Issued To";
			
			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";
			cell.innerText = "From";
			
			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";
			cell.innerText = "To";

			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";
			cell.innerText = "Private Key";

			cell = newRow.insertCell(col); col++;
    		cell.className = "CertHead";
			cell.innerText = "Thumbprint";
			row++;

			//List the objects
			var objId;
			var objType;
			var objHandle;
			var lastObject = false;
			while (lastObject == false)
			{
				objId     = getMXIToken().GetCurrentObjectId();
				objType   = getMXIToken().GetCurrentObjectType();
				objHandle = getMXIToken().GetCurrentObjectHandle();

				//Now, based on object type, print out the object information
				if (objType == "Certificate")
				{
				   //Keep track of the object used to build this row; handles will be used later to lookup certificates
   				CertViewList[row-1] = objHandle;

					var certType;
					var certIssuer;
					var certSubject;
					var certNotBefore;
					var certNotAfter;
					var certThumbPrint;
					var certHasPublicKey;
					var certHasPrivateKey;
					certType          = getMXIToken().GetCurrentCertType();
					certIssuer        = getMXIToken().GetCurrentCertIssuer();
					certSubject       = getMXIToken().GetCurrentCertSubject();
					certNotBefore     = getMXIToken().GetCurrentCertNotBefore();
					certNotAfter      = getMXIToken().GetCurrentCertNotAfter();
					certThumbPrint    = getMXIToken().GetCurrentCertThumbPrint();
					certHasPublicKey  = getMXIToken().GetCurrentCertHasPublicKey();
					certHasPrivateKey = getMXIToken().GetCurrentCertHasPrivateKey();

               var col = 0;					
					newRow = UserInformationTable.insertRow(row);
					newRow.className = "CertTableMessage";

               var cb = document.createElement("input");
               cb.type = "checkBox";                     
          		cb.name = "checkgroup";
  					cell = newRow.insertCell(col); col++;
               cell.appendChild(cb);                     
    				cell.className = "CertCell";                   
               var newHTML = "<input type=\"checkbox\" style=\"width:auto\" onclick=\"markCert(event)\"/>"
               cell.innerHTML = newHTML;

    				//DEBUG this should work but there is apparantly a BUG in IE that prevents appropriate refresh of the iframe
//             var newHTML = "<a href=\"#\" class=MXILink onclick=deleteCert(event)>" + certIssuer + "</a>";
//             var newHTML = "<a class=MXILink onclick=deleteCert(event) name=\"Item\" href=\"#Item\">" + certIssuer + "</a>";
//             var newHTML = "<a onmouseover=highlightOn(event) onmouseout=highlightOff(event) onclick=viewCert(objects,event)>" + certIssuer + "</a>";

					cell = newRow.insertCell(col); col++;
    				cell.className = "CertCell";                   
               var newHTML = "<a  onclick=viewCert(event) onmouseover=highlightOn(event) onmouseout=highlightOff(event)>" + certIssuer + "</a>";
               cell.innerHTML = newHTML;
					
					cell = newRow.insertCell(col); col++;
               var newHTML = "<a  onclick=viewCert(event) onmouseover=highlightOn(event) onmouseout=highlightOff(event)>" + certSubject + "</a>";
               cell.innerHTML = newHTML;
    				cell.className = "CertCell";
					
					cell = newRow.insertCell(col); col++;
               var newHTML = "<a  onclick=viewCert(event) onmouseover=highlightOn(event) onmouseout=highlightOff(event)>" + certNotBefore + "</a>";
               cell.innerHTML = newHTML;
    				cell.className = "CertCell";
					
					cell = newRow.insertCell(col); col++;
               var newHTML = "<a  onclick=viewCert(event) onmouseover=highlightOn(event) onmouseout=highlightOff(event)>" + certNotAfter + "</a>";
               cell.innerHTML = newHTML;
    				cell.className = "CertCell";

					cell = newRow.insertCell(col); col++;
               var newHTML = "<a  onclick=viewCert(event) onmouseover=highlightOn(event) onmouseout=highlightOff(event)>" + certHasPrivateKey + "</a>";
               cell.innerHTML = newHTML;
    				cell.className = "CertCell";

					cell = newRow.insertCell(col); col++;
               var newHTML = "<a  onclick=viewCert(event) onmouseover=highlightOn(event) onmouseout=highlightOff(event)>" + certThumbPrint + "</a>";
               cell.innerHTML = newHTML;
    				cell.className = "CertCell";
					row++;
				}
				
				lastObject = getMXIToken().NextTokenObject();
			}
		}
	}
	LogExit("Common - Scripts - Common.js - GatherTokenCertObjects");
	return;
}

function GatherUsersInfo(UserInformation)
{
	LogEntry("Common - Scripts - Common.js - GatherUsersInfo");
	var UserList = GetUserAsSpecified("", SSD_USER_LEVEL_GENERAL, "exact", false);
	var UserListDisp = GetUserAsSpecified("", SSD_USER_LEVEL_GENERAL, "display", false);
	var i = 0;
	var Num = -1;
	var UserNum = GetUserAsSpecified("", SSD_USER_LEVEL_GENERAL, "display", false).length;
	if (UserNum > 0)
	{
		Num++;
		var newRow = UserInformation.insertRow(Num);
		newRow.className = "ContentTableHeader";
		var cell = newRow.insertCell(0);
		InnerText(cell, "Number of Users: " + UserNum);
		cell.colSpan = "2";
	}
	for (i = 0; i < UserList.length; i++)
	{
		var User = getMXIDevice().User(UserList[i]);

		Num++;
		newRow = UserInformation.insertRow(Num);
		newRow.className = "ContentTableHeader";
		cell = newRow.insertCell(0);
		if (User.Privilege == SSD_USER_LEVEL_ADMINISTRATOR)
			cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/UserAdmin.gif' style='border:none;vertical-align:middle' />" + UserListDisp[i];
		else
			cell.innerHTML = "<img src='" + GetBaseDirectory() + "Common/images/UserGeneral.gif' style='border:none;vertical-align:middle' />" + UserListDisp[i];
		cell.Height = "33px";
		cell.Width = "33px";
		cell.colSpan = "2";

		Num++;
		newRow = UserInformation.insertRow(Num);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";
		if (!IsGecko())
		{
			var UID;
			if (getMXIDevice().Config.Capability(SSD_CAPABILITY_IS_UID_SUPPORTED))
				UID = User.UID(SSD_UID_TYPE_RAND);
			else
				UID = User.UID(SSD_UID_TYPE_SLOT);
			var SN = getMXIDevice().Config.SerialNumber;
			try
			{
				var UserBinding = getMXIEnt().DBUserBindings.GetDeviceUserBinding(SN, UID);
				if (!(UserBinding == null))
				{
					var aUser = getMXIEnt().DBUsers.GetUserInformation(UserBinding.LDAPUserUID());

					Num++;
					newRow = UserInformation.insertRow(Num);
					newRow.className = "ContentTableMessage";
					cell = newRow.insertCell(0);
					cell.className = "ContentTableLeftCol";
					InnerText(cell, "Active directory id: ");
					cell = newRow.insertCell(1);
					cell.className = "ContentTableRightCol";
					InnerText(cell, aUser.DN());
				}
			}catch(err)
			{
				LogInfo(err.description);
			}
		}

		Num++;
		newRow = UserInformation.insertRow(Num);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Privilege level: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, GetUserPrivilegeName(User));

		Num++;
		newRow = UserInformation.insertRow(Num);
		newRow.className = "ContentTableMessage";
		cell = newRow.insertCell(0);
		cell.className = "ContentTableLeftCol";
		InnerText(cell, "Password status: ");
		cell = newRow.insertCell(1);
		cell.className = "ContentTableRightCol";
		InnerText(cell, GetUserPwdStateName(User));

		if (User.PwdState() != SSD_PASSWORD_STATE_NOT_SET)
		{
			Num++;
			newRow = UserInformation.insertRow(Num);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Password retry limit: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			if (User.PwdRetryLimit >= SSD_BYTE_INFINITE)
				InnerText(cell, "Infinite");
			else
				InnerText(cell, User.PwdRetryLimit + 1);

         if (!IsClipDrive())
         {
			   Num++;
			   newRow = UserInformation.insertRow(Num);
			   newRow.className = "ContentTableMessage";
			   cell = newRow.insertCell(0);
			   cell.className = "ContentTableLeftCol";
			   InnerText(cell, "Password failed attempts: ");
			   cell = newRow.insertCell(1);
			   cell.className = "ContentTableRightCol";
			   InnerText(cell, User.PasswordFailedAuthenticationCount);
         }
		}
		var DevType = FindSpecificValueByName("DeviceType");
		if (DevType == "Biometric")
		{
			Num++;
			newRow = UserInformation.insertRow(Num);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Finger enrollments allowed: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			InnerText(cell, User.BioMaxAllowed);

			if (User.BioMaxAllowed > 0)
			{
				Num++;
				newRow = UserInformation.insertRow(Num);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Enrolled fingers: ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				var EnrolledFingers = GetEnrolledFingersNameList(User);
				if (EnrolledFingers[0] != null)
				{
					InnerText(cell, EnrolledFingers[0]);
					var j = 1;
					for (j = 1; j < EnrolledFingers.length; j++)
					{
						Num++;
						newRow = UserInformation.insertRow(Num);
						newRow.className = "ContentTableMessage";
						cell = newRow.insertCell(0);
						cell.className = "ContentTableLeftCol";
						cell = newRow.insertCell(1);
						cell.className = "ContentTableRightCol";
						InnerText(cell, EnrolledFingers[j]);
					}
				}

				Num++;
				newRow = UserInformation.insertRow(Num);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Biometric status: ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				if (User.BiometricBlocked == SSD_BIOMETRIC_STATE_BLOCKED)
					InnerText(cell, "Blocked");
				else
					InnerText(cell, "Active");
			  
				Num++;
				newRow = UserInformation.insertRow(Num);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Biometric retry limit: ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				if (User.BiometricRetryLimit >= SSD_BYTE_INFINITE)
					InnerText(cell, "Infinite");
				else
					InnerText(cell, User.BiometricRetryLimit + 1);

				Num++;
				newRow = UserInformation.insertRow(Num);
				newRow.className = "ContentTableMessage";
				cell = newRow.insertCell(0);
				cell.className = "ContentTableLeftCol";
				InnerText(cell, "Biometric failed attempts (user): ");
				cell = newRow.insertCell(1);
				cell.className = "ContentTableRightCol";
				InnerText(cell, User.BiometricFailedAuthenticationCount);

			}

			Num++;
			newRow = UserInformation.insertRow(Num);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Two-factor authentication: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			if (User.TwoFactor == 0)
				InnerText(cell, "No");
			else
				InnerText(cell, "Yes");
		}

		if (!IsMini())
		{
			Num++;
			newRow = UserInformation.insertRow(Num);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Encryption key size: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			InnerText(cell, User.EncryptionKeySize * 8 + " bits"); // Report size in Bits
		}
		if (!IsToken())
		{
			Num++;
			newRow = UserInformation.insertRow(Num);
			newRow.className = "ContentTableMessage";
			cell = newRow.insertCell(0);
			cell.className = "ContentTableLeftCol";
			InnerText(cell, "Private partition size: ");
			cell = newRow.insertCell(1);
			cell.className = "ContentTableRightCol";
			InnerText(cell, User.PartitionSize + " MB");
		}

		Num++;
		newRow = UserInformation.insertRow(Num);
		newRow.className = "Spacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";

		Num++;
		newRow = UserInformation.insertRow(Num);
		newRow.className = "TableSpacer";
		cell = newRow.insertCell(0);
		cell.className = "FirstOutputCol";
		cell = newRow.insertCell(1);
		cell.className = "SecondOutputCol";

	}

	LogExit("Common - Scripts - Common.js - GatherUsersInfo");
	return;
}

function GetBioSecValName(BioSecLev)
{
	LogEntry("Common - Scripts - Common.js - GetBioSecValName");
	var Result = "";
	switch(BioSecLev)
	{
	case BIOSecLevelRatio[0]:
		Result = BIOSecLevelDisplay[0];
		break;
	case BIOSecLevelRatio[1]:
		Result = BIOSecLevelDisplay[1];
		break;
	case BIOSecLevelRatio[2]:
		Result = BIOSecLevelDisplay[2];
		break;
	case BIOSecLevelRatio[3]:
		Result = BIOSecLevelDisplay[3];
		break;
	case BIOSecLevelRatio[4]:
		Result = BIOSecLevelDisplay[4];
		break;
	}
	LogExit("Common - Scripts - Common.js - GetBioSecValName");
	return Result;
}

function GetUserPwdStateName(User)
{
	LogEntry("Common - Scripts - Common.js - GetUserPwdStateName");
	var Result = "";
	switch(User.PwdState())
	{
	case SSD_PASSWORD_STATE_NOT_SET:
		Result = "Not set";
	case SSD_PASSWORD_STATE_BLOCKED:
		Result = "Blocked";
	case SSD_PASSWORD_STATE_OK:
		Result = "Set";
//	case SSD_PASSWORD_SSD_PASSWORD_STATE_CHANGESTATE_NOT_SET:
//		return "Must change";
	}
	LogExit("Common - Scripts - Common.js - GetUserPwdStateName");
	return Result;
}

function GetEnrolledFingersNameList(User)
{
	LogEntry("Common - Scripts - Common.js - GetEnrolledFingersNameList");
	var fingerList = User.EnrolledFingers;
	var fingerCount;
	if (fingerList == "")
		fingerCount = 0;
	else
		fingerCount = fingerList.split(" ").length;

  var FingerList = User.EnrolledFingers.split(" ");
  var FingerArray = new Array(fingerCount);
  var i;
  for (i=0; i < fingerCount; i++)
  {
	 FingerArray[i] = GetFingerName(FingerList[i]);
  }
  LogExit("Common - Scripts - Common.js - GetEnrolledFingersNameList");
  return FingerArray;
}

function GetFingerName(FingerNum)
{
	LogEntry("Common - Scripts - Common.js - GetFingerName");
	var Result = "";
	switch(parseInt(FingerNum))
	{
	case 0:
		Result = "left pinky";
		break;
	case 1:
		Result = "left ring";
		break;
	case 2:
		Result = "left middle";
		break;
	case 3:
		Result = "left index";
		break;
	case 4:
		Result = "left thumb";
		break;
	case 5:
		Result = "right thumb";
		break;
	case 6:
		Result = "right index";
		break;
	case 7:
		Result = "right middle";
		break;
	case 8:
		Result = "right ring";
		break;
	case 9:
		Result = "right pinky";
		break;
	}
	LogExit("Common - Scripts - Common.js - GetFingerName");
	return Result;
}

function GetErrorMsg(ErrorCode, Extra)
{
	LogEntry("Common - Scripts - Common.js - GetErrorMsg");
	var errorMsg = "";
	if (ErrorCode != SSD_RET_HTML_INTERNAL)
	{
		if (ErrorCode < 0x0)
			ErrorCode &= 0x0000FFFF;
	}
	switch(ErrorCode)
	{
		case SSD_RET_HTML_INTERNAL:
			errorMsg =getMXISession().GetValue("Message");
			if (errorMsg == null)
				errorMsg = "An unexpected error occurred.";
			break;
		case SSD_RET_OK:
			errorMsg = "Success.";
			break;
		case SSD_RET_INVALID_PARAMETER:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_OUTOFMEM:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_MSG_AVAILABLE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_ALREADY_PRESENT:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_NOT_IMPLEMENTED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_NOT_SUPPORTED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_INVALID_HANDLE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_LIBNOTINIT:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_INVALID_DATA:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_INVALID_STATE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_LIB_OS_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_INTERNAL_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_INVALID_SEQUENCE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_IO_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_ITEM_NOT_FOUND:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_OPERATION_NOT_ALLOWED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_EXCLUSIVE_ACCESS_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_VER_NOT_SUPPORTED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_VER_CORRUPTED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_VER_UPDATE_REQUIRED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_MORE_FACTOR_REQUIRED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_OFFSET:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_INVALID_CMD:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_OUTOFMEMORY:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_DATA_CORRUPTED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_INVALID_SLOTID:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_NO_USER:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_EEPROM:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_INVALID_PARAM:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_DATA_NOTINIT:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_CONTINUE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_FPSENSOR_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_ENROLL_TEMP_NOT_STORE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_ENROLL_FINGERDATA_NOT_STORED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_SENSOR_NO_RESPONSE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_SENSOR_INVALID_RESPONSE:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_ENROLL_INVALID_SLOT:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_ENROLL_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_SYSTEM_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_CRYPTO_ERROR:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_DEV_MORE_FACTOR_REQUIRED:
			errorMsg = "An internal error occurred. (" + ErrorCode + ")";
			break;
		case SSD_RET_TIMEOUT:
			errorMsg = "An operation timed out.";
			break;
		case SSD_RET_DEV_TIMEOUT:
			errorMsg = "An operation timed out.";
			break;
		case SSD_RET_OUT_OF_RANGE:
			errorMsg = "The value specified is not in the acceptable range.";
			break;
		case SSD_RET_DEVICE_LOCKED:
			errorMsg = "Device is currently locked.";
			break;
		case SSD_RET_INVALID_USERNAME:
			errorMsg = "An invalid user name specified.";
			break;
		case SSD_RET_CANCELLED:
			errorMsg = "An operation was cancelled.";
			case SSD_RET_FILE_NOT_FOUND:
			if (Extra == "")
				errorMsg = "File does not exist.";
			else
				errorMsg = "The file: '" + Extra + "' could not be found.";
			break;
		case SSD_RET_ACCESS_DENIED:
			errorMsg = "Access Denied.";
			if (Extra != "")
				errorMsg += "\n" + Extra;
			break;
		case SSD_RET_DEV_ACCESS_DENIED:
			errorMsg = "Access Denied.";
			if (Extra != "")
				errorMsg += "\n" + Extra;
			break;
		case SSD_RET_FIRMWARE_UPDATE_COMPLETED:
			errorMsg = "Firmware has been updated, disonnect and reconnect your device.";
			break;
		case SSD_RET_LAST_AUTH_TRY:
			errorMsg = "This is your last authentication attempt.";
			break;
		case SSD_RET_ALREADY_UNLOCKED_OTHER:
			errorMsg = "Another user has already unlocked the device.";
			break;
		case SSD_RET_DEV_LOCKED:
			errorMsg = "The device is locked.";
			break;
		case SSD_RET_DEV_BLOCKED:
			errorMsg = "The device is blocked for biometric identification.";
			break;
		case SSD_RET_DEV_ALREADY_UNLOCKED:
			errorMsg = "The device is already unlocked.";
			break;
		case SSD_RET_PWD_BLOCKED:
			errorMsg = "Your password authentication method is blocked.";
			break;
		case SSD_RET_BIO_BLOCKED:
			errorMsg = "Your biometric authentication method is blocked.";
			break;
		case SSD_RET_DEV_CANCELBIO:
			errorMsg = "A biometric operation was cancelled.";
			break;
		case SSD_RET_DEV_ENROLL_GOT_MATCH:
			errorMsg = "This finger matches one already enrolled on the device.";
			break;
		case SSD_RET_DEV_POOR_IMAGE:
			errorMsg = "The fingerprint image quality is too low.";
			break;
		case SSD_RET_MIN_PWD_LENGTH:
			errorMsg = "The minimum length rule was not respected. " + Extra;
			break;
		case SSD_RET_MIN_NUM_CHAR:
			errorMsg = "The minimum number of numeric characters rule was not respected. " + Extra;
			break;
		case SSD_RET_MIN_ALPHA_CHAR:
			errorMsg = "The minimum number of alpabetical characters rule was not respected. " + Extra;
			break;
		case SSD_RET_MIN_UPPER_CHAR:
			errorMsg = "The minimum number of uppercase characters rule was not respected. " + Extra;
			break;
		case SSD_RET_MIN_LOWER_CHAR:
			errorMsg = "The minimum number of lowercase characters rule was not respected. " + Extra;
			break;
		case SSD_RET_MIN_SPEC_CHAR:
			errorMsg = "The minimum number of special characters rule was not respected. " + Extra;
			break;
		case SSD_RET_PWD_RE_USE:
			errorMsg = "The password has already been used and may not be re-used before the re-use threshold is reached. " + Extra;
			break;
		case SSD_RET_PWD_EXPIRED:
			errorMsg = "The password has reached its maximum life expectancy and must be changed. " + Extra;
			break;
		case SSD_RET_PWD_FROZEN:
			errorMsg = "The password may not be changed before the minimum lifetime is reached. " + Extra;
			break;
		default:
			errorMsg = GetWarningMsg(ErrorCode, Extra);
			break;
	}
	LogExit("Common - Scripts - Common.js - GetErrorMsg");
	return errorMsg;
}

function GetWarningMsg(WarningNum, Extra)
{
	LogEntry("Common - Scripts - Common.js - GetWarningMsg");
	var warningMsg = "";
	switch (WarningNum)
	{
		case SSD_SCRIPT_WARN_BIO_LAST:
			if (Extra != "")
				warningMsg = "If you fail to authenticate again, " + Extra + "'s access to the device using the biometric authentication method will be blocked.";
			else
				warningMsg = "If you fail to authenticate again, your access to the device using the biometric authentication method will be blocked.";
		case SSD_SCRIPT_WARN_PWD_LAST:
			if (Extra != "")
				warningMsg = "If you fail to authenticate again, " + Extra + "'s access to the device using the password authentication method will be blocked.";
			else
				warningMsg = "If you fail to authenticate again, your access to the device using the password authentication method will be blocked.";
		case SSD_SCRIPT_WARN_BIO_BLOCKED:
			if (Extra != "")
				warningMsg = Extra + "'s biometric authentication method is now BLOCKED.";
			else
				warningMsg = "The device is now BLOCKED for biometric identification, please select a specific user and try again.";
		case SSD_SCRIPT_WARN_PWD_BLOCKED:
			warningMsg = Extra + "'s password authentication method is now BLOCKED.";
		case SSD_SCRIPT_WARN_LAST_AUTH_METHOD:
			if (Extra != "")
				warningMsg = "Deleting " + Extra + "'s last method of authentication will render their ";
			else
				warningMsg = "Deleting the users last method of authentication will render their ";

			if (IsToken())
				warningMsg += "private store information no longer accessible.";
			else
				warningMsg += "partition and private store information no longer accessible.";
		case SSD_SCRIPT_WARN_ACCESS_DENIED:
			warningMsg = "Access Denied.";
			if (Extra != "")
				warningMsg += "\n" + Extra;
		case SSD_SCRIPT_WARN_BIOSENSOR_FAILURE:
			warningMsg = "The device's biometric sensor has failed.";
		case SSD_SCRIPT_WARN_MIN_PWD_LENGTH:
			warningMsg = "The minimum password length is " + SSD_MIN_PWD_LENGTH;
		case SSD_SCRIPT_WARN_MAX_PWD_LENGTH:
			warningMsg = "The minimum password length may not be greater than " + Extra + ".";
		case SSD_SCRIPT_WARN_MUST_SELECT_FINGER:
			warningMsg = "You must select a finger before continuing.";
		case SSD_SCRIPT_WARN_MUST_ENROLL_FINGER:
			warningMsg = "You do not have any enrolled fingerprints to delete.";
		case SSD_SCRIPT_WARN_MUST_DELETE_FINGER:
			warningMsg = "You must delete a fingerprint before you can enroll a new one.";
		case SSD_SCRIPT_WARN_INVALID_VALUE:
			warningMsg = "Invalid value provided.";
			if (Extra != "")
				warningMsg += " (" + Extra + ").";
		case SSD_SCRIPT_WARN_ADMIN_REQUIRED:
			warningMsg = "To perform this operation, you must authenticate to the device as an administrator.";
			if (Extra != "")
				warningMsg += " (" + Extra + ")";
		case SSD_SCRIPT_WARN_ADMIN_MISSING:
			warningMsg = "This operation requires administrative privileges. However, no administrative account is available.\nYou must recycle the device.";
		case SSD_SCRIPT_WARN_LOCK_PERMISSION:
			warningMsg = "You do not have the permissions required to lock the device.\nYou should perform a safe removal of the device.";
		case SSD_SCRIPT_WARN_PWD_REQUIRED:
			warningMsg = "A valid password is required.";
		case SSD_SCRIPT_WARN_PWD_MATCH:
			warningMsg = "Passwords do not match.";
		case SSD_SCRIPT_WARN_PWD_LENGTH_TOO_SMALL:
			if (Extra != "")
				warningMsg = "The password you enter must be at least " + Extra + " characters long.";
			else
				warningMsg = "Password length is out of valid range.";
		case SSD_SCRIPT_WARN_PWD_LENGTH_TOO_BIG:
			if (Extra != "")
				warningMsg = "The password you enter must be at most " + Extra + " characters long.";
			else
				warningMsg = "Password length is out of valid range.";
		case SSD_SCRIPT_WARN_INVALID_USERNAME_LEAD:
			warningMsg = "User name may not start or finish with spaces.";
		case SSD_SCRIPT_WARN_INVALID_USERNAME_CHAR:
			warningMsg = "User name may not contain any of the following characters" + Extra;
		case SSD_SCRIPT_WARN_USER_REQUIRED:
			warningMsg = "Please provide a valid user name";
			if (Extra != "")
				warningMsg += " in order to perform a " + Extra + ".";
			else
				warningMsg += ".";
		case SSD_SCRIPT_WARN_UNKNOWN_DEVICE:
			warningMsg = "The inserted device is not recognized. Please remove it and insert another one.";
		case SSD_SCRIPT_WARN_NO_USER_BIOMETRIC:
			warningMsg = "No user is available with valid biometric enrollments.\nPlease enroll a fingerprint for at least one user and try again.";
		case SSD_SCRIPT_WARN_NO_USER_TWO_FACTOR:
			warningMsg = "No user is available with valid two-factor authentication method.\nYou may need to unblock your biometric or password method and try again.";
		case SSD_SCRIPT_WARN_NO_USER_PASSWORD:
			warningMsg = "No user is available with a valid password. Please set a password and try again.";
		case SSD_SCRIPT_WARN_USER_MISSING:
			warningMsg = "The user '" + Extra + "' does not exist."
		case SSD_SCRIPT_WARN_AUTH_CANCELLED:
			warningMsg = Extra + " operation will not be executed.\nAre you sure you want to exit?";
		case SSD_SCRIPT_WARN_DISABLE_PUBLIC:
			warningMsg = "This device has a public partition.\nYou may choose to either keep this partition or disable it.  Disabling will destroy any data stored on the partition.\nDo you want to disable the public partition?";
		case SSD_SCRIPT_WARN_NO_USER_SPACE:
			warningMsg = "There is not enough space available to create a user."
		case SSD_SCRIPT_WARN_NO_DRIVE_NOT_FOUND:
			warningMsg = "The private drive could not be found.\nPlease verify that a network path is not mapped at the usual mass storage drive letter.";
		case SSD_SCRIPT_WARN_FORMAT_FAILED:
			if (Extra != "")
				warningMsg = "Unable to format the " + Extra + " partition.";
			else
				warningMsg = "Unable to format the partition.";
		case SSD_SCRIPT_WARN_FLUSH_FAILED:
			if (Extra != "")
				warningMsg = "Unable to flush the " + Extra + " partition.";
			else
				warningMsg = "Unable to flush the partition.";
		case SSD_SCRIPT_WARN_LOCK_FAILED:
			warningMsg = "The lock operation failed.\nVerify that the drive is not currently in use and try again.";
		case SSD_SCRIPT_WARN_MUST_BE_NUMERIC:
			warningMsg = "The " + Extra + " must be a numeric value.";
		case SSD_SCRIPT_WARN_PKCS12_FILENAME_MISSING:
			warningMsg = "The PKCS#12 filename is missing.";
			if (Extra != "")
				warningMsg += "\n" + Extra;
		case SSD_SCRIPT_WARN_STORE_INNACCESSIBLE:
			if (Extra == "")
				warningMsg = "The store you are attempting to access is not accessible.";
			else
				warningMsg = "The " + Extra + "store is not accessible.";
		case SSD_SCRIPT_WARN_USER_EXIST:
			warningMsg = "The user '" + Extra + "' already exists.";
		case SSD_SCRIPT_WARN_PROMPT_DELETE_FINGER:
			warningMsg = "Continuing will delete your " + Extra + " enrollment.";
		case SSD_SCRIPT_WARN_NO_MORE_FINGER_SLOT:
			warningMsg = "There are no fingers left to enroll.";
		default:
			warningMsg = "Unexpected error ("  + WarningNum + ").";
	}
	LogExit("Common - Scripts - Common.js - GetWarningMsg");
	return warningMsg;
}

function GetMXICERTErrorMsg(ErrorCode)
{
	LogEntry("Common - Scripts - Common.js - GetMXICERTErrorMsg");
	var errMsg = "";
	if (ErrorCode != SSD_RET_HTML_INTERNAL)
	{
		if (ErrorCode < 0x0)
			ErrorCode &= 0x0000FFFF;
	}
	switch(ErrorCode)
	{
		case SSD_RET_OK:
			errMsg = "Success.";
			break;
      case ERROR_CERT_ACCESS_DENIED:
         errMsg = Str_CERT_ACCESS_DENIED;
         break;
      case ERROR_CERT_NO_CONNECTION:
         errMsg = Str_CERT_NO_CONNECTION;
         break;
      case ERROR_CERT_CONNECTION_ERROR:
         errMsg = Str_CERT_CONNECTION_ERROR + getMXICert().LastErrorString;
         break;
      case ERROR_CERT_CA_NAME_NOT_SET:
         errMsg = Str_CERT_CA_NAME_NOT_SET;
         break;
      case ERROR_CERT_OBJECT_NOT_INIT:
         errMsg = Str_CERT_OBJECT_NOT_INIT;
         break;
      case ERROR_CERT_NO_ENROLLMENT_CERT:
         errMsg = Str_CERT_NO_ENROLLMENT_CERT;
         break;
      case ERROR_CERT_NOT_LICENSED:
         errMsg = Str_CERT_NOT_LICENSED;
         break;
      case ERROR_CERT_REQUEST_FAILED:
         errMsg = Str_CERT_REQUEST_FAILED + getMXICert().LastErrorString;;
         break;
      case ERROR_CERT_P12_PASSWORD:
         errMsg = Str_CERT_P12_PASSWORD;
         break;
      case ERROR_CERT_KEY_ARCHIVE_NOT_SUPPORTED:
         errMsg = Str_CERT_KEY_ARCHIVE_NOT_SUPPORTED;
         break;
      case ERROR_CERT_DISP_INCOMPLETE:
         errMsg = Str_CERT_DISP_INCOMPLETE;
         break;
      case ERROR_CERT_DISP_DISP_ERROR:
         errMsg = Str_CERT_DISP_DISP_ERROR;
         break;
      case ERROR_CERT_DISP_DISP_DENIED:
         errMsg = Str_CERT_DISP_DISP_DENIED;
         break;
      case ERROR_CERT_DISP_DISP_OUT_OF_BAND:
         errMsg = Str_CERT_DISP_DISP_OUT_OF_BAND;
         break;
      case ERROR_CERT_DISP_DISP_UNDER_SUBMISSION:
         errMsg = Str_CERT_DISP_DISP_UNDER_SUBMISSION;
         break;
      case ERROR_CERT_DISP_DISP_REVOKED:
         errMsg = Str_CERT_DISP_DISP_REVOKED;
         break;
      case ERROR_CERT_OUT_OF_MEMORY:
         errMsg = Str_CERT_OUT_OF_MEMORY;
         break;
      case ERROR_CERT_BASE64_ENCODE:
         errMsg = Str_CERT_BASE64_ENCODE;
         break;
      case ERROR_CERT_BASE64_DECODE:
         errMsg = Str_CERT_BASE64_DECODE;
         break;
      case ERROR_CERT_FILE_ERROR:
         errMsg = Str_CERT_FILE_ERROR;
         break;
      case ERROR_CERT_KEY_GENERATION:
         errMsg = Str_CERT_KEY_GENERATION + getMXICert().LastErrorString;
         break;
      case ERROR_CERT_KEY_INVAILD_KEY:
         errMsg = Str_CERT_KEY_INVAILD_KEY;
         break;
      case ERROR_CERT_PLATFORM_NOT_SUPPORTED:
         errMsg = Str_CERT_PLATFORM_NOT_SUPPORTED;
         break;
      default:
         errMsg = "Unexpected error ("  + ErrorCode + ").";
         break;
         
	}
	LogExit("Common - Scripts - Common.js - GetMXICERTErrorMsg");
	return errMsg;
}

//<!--##################################-->
function FilterName(Name)
{
	LogEntry("Common - Scripts - Common.js - FilterName");
	if (Name == "_Admin")
		Name = "Administrator";
	
	LogExit("Common - Scripts - Common.js - FilterName");
	return Name
}

//<!--##################################-->
function getNumUser()
{
	LogEntry("Common - Scripts - Common.js - getNumUser");
	var UserList = getMXIDevice().UserListAll().split(SSD_LIST_SEPERATOR);
	LogExit("Common - Scripts - Common.js - getNumUser");
	return UserList.length;
}

//<!--##################################-->
function GetCurUserPrivilegeLevel()
{
	LogEntry("Common - Scripts - Common.js - GetCurUserPrivilegeLevel");
	var result = SSD_INVALID_VALUE;
	if (getMXIDevice().state == SSD_DEVICE_STATE_UNLOCKED)
	{
		var UserName = getMXIDevice().CurrentUser;
		if (UserName != "")
			result = getMXISDK().User(UserName).Privilege;
	}
	LogExit("Common - Scripts - Common.js - GetCurUserPrivilegeLevel");
	return result;
}

//<!--##################################-->
function GetUserPrivilegeName(User)
{
	LogEntry("Common - Scripts - Common.js - GetUserPrivilegeName");
	var Result = ""
	switch (User.Privilege)
	{
	case SSD_USER_LEVEL_ADMINISTRATOR:
		Result =  "Administrator";
	case SSD_USER_LEVEL_GENERAL:
		Result =  "General";
	}
	LogExit("Common - Scripts - Common.js - GetUserPrivilegeName");
	return Result;
}

function IsUserBioBlocked()
{
	LogEntry("Common - Scripts - Common.js - IsUserBioBlocked");
	var Result = false;
	var GeneralUser = parseInt(FindSpecificValueByName("General User"));
	var UserList = GetUsers(GeneralUser);
	var i = 0;
	while (UserList[i] != null)
	{
		if (getMXIDevice().User(UserList[i]).BiometricBlocked() == 1)
			Result = true;
		i++;
	}
	LogExit("Common - Scripts - Common.js - IsUserBioBlocked");
	return Result;
}

function LockDevice()
{
	LogEntry("Common - Scripts - Common.js - LockDevice");
	var PrivateDrive = getMXIDevice().DriveName(SSD_DEVICE_MOUNTTYPE_PRIVATE);
	if (getMXIUtil().IsNTFSDrive(PrivateDrive))
	{
		if (!getMXIUtil().SafelyEjectDrive(PrivateDrive))
		{
		   ShowWarning(Str_Issue_LogoutFailed);
	   }
	}
	else
	{
		try
		{
			getMXIDevice().LockDev();
		}
		catch(err)
		{
			ShowWarning(Str_Issue_LogoutFailed);
		}
	}
	LogExit("Common - Scripts - Common.js - LockDevice");
	return;
}

function IsClipDrive()
{
	LogEntry("Common - Scripts - Common.js - IsClipDrive");
	var Result = false;
	if (getMXIDevice().Config.KindID == SSD_DEVICE_TYPE_CLIPDRIVE || getMXIDevice().Config.KindID == SSD_DEVICE_TYPE_CLIPDRIVE_BIO)
		Result = true;

	LogExit("Common - Scripts - Common.js - IsClipDrive");
	return Result;
}

function IsToken()
{
	LogEntry("Common - Scripts - Common.js - IsToken");
	var Result = false;
	if (getMXIDevice().Config.KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_BIO_TOKEN || getMXIDevice().Config.KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_TOKEN)
		Result = true;

	LogExit("Common - Scripts - Common.js - IsToken");
	return Result;
}

function IsMini()
{
	LogEntry("Common - Scripts - Common.js - IsMini");
	var Result = false;
	if (getMXIDevice().Config.KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_MINI)
		Result = true;

	LogExit("Common - Scripts - Common.js - IsMini");
	return Result;
}
//*************************************************
//**************** mxiVbUtil.vbs ******************
//*************************************************

//****************************************************************
//
// Conversion Functions
//
//****************************************************************
/*function CompareCOMError(SDKError, COMError)
{
	LogEntry("Common - Scripts - Common.js - CompareCOMError");
	var Result = false;
	if ((0x80040000 + SDKError) == COMError)
		Result = true;

	LogExit("Common - Scripts - Common.js - CompareCOMError");
	return Result;
}

function ConvertCOMError(COMError)
{
	LogEntry("Common - Scripts - Common.js - ConvertCOMError");
	var Result = COMError
	if (COMError > 0x80000000 && COMError < 0x80A90000)
		Result = (0x80A80000 - COMError);

	LogExit("Common - Scripts - Common.js - ConvertCOMError");
	return Result;
}*/

function InitializeSDK()
{
	LogEntry("Common - Scripts - Common.js - InitializeSDK");
	if (getMXISession().IsPresent("SDKInitialized") == false)
	{
		getMXIDevice().Initialize();
		getMXISession().SetValue("SDKInitialized", "TRUE");
	}
	LogExit("Common - Scripts - Common.js - InitializeSDK");
	return;
}

//------------------------------------
// Session Object handling
//------------------------------------

function Session_GetUsername()
{
	LogEntry("Common - Scripts - Common.js - Session_GetUsername");
	var Result = "";
	 // Get username
	if (getMXISession().IsPresent("Username") == false)
	{
		ShowError("A required object (Username) is not set in the session manager");
	}
	else
	{
		Result = getMXISession().GetValue("Username");
	}
	LogExit("Common - Scripts - Common.js - Session_GetUsername");
	return Result;
}

//---------------------------------------------------
// GetDefaultUserPassword
//---------------------------------------------------
function GetDefaultUserPassword()
{
	LogEntry("Common - Scripts - Common.js - GetDefaultUserPassword");
	LogExit("Common - Scripts - Common.js - GetDefaultUserPassword");
	return getMXIUtil().ReadConfigValue("./Config/Presenter.ini", "Configuration", "DefaultUserPassword", "");
}

var upperCaseChars = "ABCDEFGHJKLMNPQRSTUVWXYZ";
var lowerCaseChars = "abcdefghijkmnopqrstuvwxyz";
var alpha = upperCaseChars + lowerCaseChars;
var numberChars = "1234567890";
var specialChars = "~`!@#$%^&*()_-+=[]<>,.?/:;\\|{}";
var validChars = alpha + numberChars + specialChars;
//---------------------------------------------------
// GenerateUserPassword
//---------------------------------------------------
function GenerateUserPassword(size, chars, upper, lower, num, spec)
{
	LogEntry("Common - Scripts - Common.js - GenerateUserPassword");
	var password = GetDefaultUserPassword();
	if (password == "")
	{
		password = GetRandomStrWithRules(size, chars, upper, lower, num, spec);
	}
	else if ( (password.length < size) || (spec > GetNumberOfCharacter(password, specialChars)) || (num > GetNumberOfCharacter(password, numberChars)) || (lower > GetNumberOfCharacter(password, lowerCaseChars)) || (upper > GetNumberOfCharacter(password, upperCaseChars)) || (chars > GetNumberOfCharacter(password, alpha)))
	{
		ShowWarning(Str_Pwd_DefaultDoesNotConform);
		password = GetRandomStrWithRules(size, chars, upper, lower, num, spec);
	}
	LogExit("Common - Scripts - Common.js - GenerateUserPassword");
	return password;
}

//---------------------------------------------------
// GetRandomStrWithRules - human-readable, appropriate for passwords
//---------------------------------------------------
function GetRandomStrWithRules(size, chars, upper, lower, num, spec)
{
	LogEntry("Common - Scripts - Common.js - GetRandomStrWithRules");
	var i = 0;
	var offset = 0;
	var tmpStr = "";
	for (i = 0; i <= (upper - 1); i++)
	{	
		offset = parseInt(upperCaseChars.length * Math.random());
		tmpStr = tmpStr + upperCaseChars.substring(offset, offset + 1);
	}
	for (i = 0; i <= (lower - 1); i++)
	{	
		offset = parseInt(lowerCaseChars.length * Math.random());
		tmpStr = tmpStr + lowerCaseChars.substring(offset, offset + 1);
	}
	for (i = tmpStr.length; i <= (chars - 1); i++)
	{	
		offset = parseInt(alpha.length * Math.random());
		tmpStr = tmpStr + alpha.substring(offset, offset + 1);
	}
	for (i = 0; i <= (num - 1); i++)
	{	
		offset = parseInt(numberChars.length * Math.random());
		tmpStr = tmpStr + numberChars.substring(offset, offset + 1);
	}
	for (i = 0; i <= (spec - 1); i++)
	{	
		offset = parseInt(specialChars.length * Math.random());
		tmpStr = tmpStr + specialChars.substring(offset, offset + 1);
	}
	for (i = tmpStr.length; i <= (size - 1); i++)
	{	
		offset = parseInt(validChars.length * Math.random());
		tmpStr = tmpStr + validChars.substring(offset, offset + 1);
	}
	var str = "";
	for (i = 0; i <= (size - 1); i++)
	{
		offset = parseInt(tmpStr.length * Math.random());
		str = str + tmpStr.substring(offset, offset + 1);
		tmpStr = tmpStr.substring(0, offset) + tmpStr.substring(offset + 1);
	}
	LogExit("Common - Scripts - Common.js - GetRandomStrWithRules");
	return str;
}


//---------------------------------------------------
// GetNumberOfCharacter
//---------------------------------------------------
function GetNumberOfCharacter( Str, Characters )
{
	LogEntry("Common - Scripts - Common.vbs - GetNumberOfSpecial");
	var Result = 0;
	var i;
	var tmpStr = Str;
	for(i = 0; i < tmpStr.length; i += 1)
	{
		var nextChar = tmpStr.substring(i, i + 1);
		var index = Characters.indexOf(nextChar);
		if (index != -1)
		{
			Result = Result + 1
		}
	}
	LogExit("Common - Scripts - Common.vbs - GetNumberOfSpecial")
	return Result;
}

function Session_CachePassword(password)
{
	LogEntry("Common - Scripts - Common.js - Session_CachePassword");
	getMXISession().SetValue("PasswordCache", password);
	LogExit("Common - Scripts - Common.js - Session_CachePassword");
	return;
}

function Session_ClearCachedPassword()
{
	LogEntry("Common - Scripts - Common.js - Session_ClearCachedPassword");
	getMXISession().RemoveValue("PasswordCache")
	LogExit("Common - Scripts - Common.js - Session_ClearCachedPassword");
	return;
}

function Session_GetCachedPassword()
{
	LogEntry("Common - Scripts - Common.js - Session_GetCachedPassword");
	var Result = "";
	// Get username
	if (getMXISession().IsPresent("PasswordCache") != false)
		Result = getMXISession().GetValue("PasswordCache");
	
	LogExit("Common - Scripts - Common.js - Session_GetCachedPassword");
	return Result;
}

// Authentication Type
function Session_SetAuthenticationType(authType)
{
	LogEntry("Common - Scripts - Common.js - Session_SetAuthenticationType");
	getMXISession().SetValue("AuthenticationType", authType);
	LogExit("Common - Scripts - Common.js - Session_SetAuthenticationType");
	return;
}

function Session_GetAuthenticationType()
{
	LogEntry("Common - Scripts - Common.js - Session_GetAuthenticationType");
	var Result = AUTH_TYPE_LOGIN;
	if (getMXISession().IsPresent("AuthenticationType") != false)
		Result = getMXISession().GetValue("AuthenticationType");
	
	LogExit("Common - Scripts - Common.js - Session_GetAuthenticationType");
	return Result;
}

function Session_ClearAuthenticationType()
{
	LogEntry("Common - Scripts - Common.js - Session_ClearAuthenticationType");
	getMXISession().RemoveValue("AuthenticationType");
	LogExit("Common - Scripts - Common.js - Session_ClearAuthenticationType");
	return;
}

function Session_SetValidatedFlag()
{
	LogEntry("Common - Scripts - Common.js - Session_SetValidatedFlag");
	getMXISession().SetValue("SessionValidated", "1");
	LogExit("Common - Scripts - Common.js - Session_SetValidatedFlag");
	return;
}

function Session_ClearValidatedFlag()
{
	LogEntry("Common - Scripts - Common.js - Session_ClearValidatedFlag");
	getMXISession().SetValue("SessionValidated", "0");
	LogExit("Common - Scripts - Common.js - Session_ClearValidatedFlag");
	return;
}

function Session_IsValidated()
{
	LogEntry("Common - Scripts - Common.js - Session_IsValidated");
	var Result = false;
	if (getMXISession().IsPresent("SessionValidated"))
	{
		if (getMXISession().GetValue("SessionValidated") == "1")
			Result = true;
	}
	LogExit("Common - Scripts - Common.js - Session_IsValidated");
	return Result;
}

//*********************************************
//**************** utils.vbs ******************
//*********************************************

//---------------------------------------------------------------
// Function LogTrace()
//---------------------------------------------------------------
/*function LogTrace(module, aString)
{  
	LogInfo(("(" + module + ") " + aString));
}*/

//***************************************	
// Message box helpers
//***************************************		
function ShowInfo(message)
{
	LogInfo("Info: " + message);
	getMXIBrowser().MsgBox(message, MB_ICONINFORMATION | MB_OK, getMXIUtil().ReadConfigValue("./SSDAPI.ini", "Branding", "PRODUCT_NAME", "McAfee Encrypted USB"));
}

function ShowError(message)
{
	LogInfo("Error: " + message);
	getMXIBrowser().MsgBox(message, MB_ICONSTOP | MB_OK, getMXIUtil().ReadConfigValue("./SSDAPI.ini", "Branding", "PRODUCT_NAME", "McAfee Encrypted USB"));
}

function ShowWarning(message)
{
	LogInfo("Warning: " + message);
	getMXIBrowser().MsgBox(message, MB_ICONEXCLAMATION | MB_OK, getMXIUtil().ReadConfigValue("./SSDAPI.ini", "Branding", "PRODUCT_NAME", "McAfee Encrypted USB"));
}

function ShowYesNo(message)
{
	return getMXIBrowser().MsgBox(message, MB_ICONQUESTION | MB_YESNO, getMXIUtil().ReadConfigValue("./SSDAPI.ini", "Branding", "PRODUCT_NAME", "McAfee Encrypted USB"));
}

function ShowOkCancel(message)
{
	LogEntry("Common - Scripts - Common.js - ShowOkCancel");
	LogExit("Common - Scripts - Common.js - ShowOkCancel");
	return getMXIBrowser().MsgBox(message, MB_OKCANCEL, getMXIUtil().ReadConfigValue("./SSDAPI.ini", "Branding", "PRODUCT_NAME", "McAfee Encrypted USB"));
}

function MessageBox(message, flags, caption)
{
	LogEntry("Common - Scripts - Common.js - MessageBox");
	LogExit("Common - Scripts - Common.js - MessageBox");
	return getMXIBrowser().MsgBox(message, flags, caption);
}

// ******************************************
// * Generic Error Handling
// ******************************************

// ******************************************
// * Method used to populate a dropdown list
// ******************************************
function AddListItem( lb, strDispText, strValue, strId)
{
	LogEntry("Common - Scripts - Common.js - AddListItem");
	var newOpt;
	newOpt = curWindow().document.createElement("option");
	newOpt = new Option(strDispText, strValue);
	newOpt.id = strId;
	newOpt.title = strDispText;
	if (IsGecko())
	{
		lb.add(newOpt, null);
	}
	else
	{
		lb.add(newOpt);
	}
	LogExit("Common - Scripts - Common.js - AddListItem");
	return;
}

function List_onchange(ListName)
{
	var Elem = document.getElementById(ListName);
	setListTitle(Elem);
}

function setListTitle(ListElem)
{
	if (ListElem.selectedIndex != -1)
	{
		ListElem.title = ListElem.options[ListElem.selectedIndex].text
	}
}

// ******************************************
// * Method used to clear a dropdown list
// ******************************************
function RemoveAll( lb )
{
	LogEntry("Common - Scripts - Common.js - RemoveAll");
	for(var i=lb.children.length-1;i>=0;i--)
		lb.remove(i);
	
	LogExit("Common - Scripts - Common.js - RemoveAll");
	return;
}

// First 2 bytes are always the version
// Version "01"
// - F2F - offset = 2, size = 1
// - TwoFactor - offset = 3, size = 1
function ReadROFlag(flagName)
{
	LogEntry("Common - Scripts - Common.js - ReadROFlag");
	var value = "";

	var store = getMXIDevice().PublicStore();

	if (store.FileExist("SSDAEFLG"))
	{
		// Read the version - first two bytes are the version
		var version = Base64.decode(store.Read("SSDAEFLG", 0, 2));
		if (version != "")
		{
			switch(version)
			{
			case "01":
				switch(flagName)
				{
				case ROFlag_IssueMode:
					value = Base64.decode(store.Read("SSDAEFLG", 2, 1));
					break;
				case ROFlag_TwoFactor:
					value = Base64.decode(store.Read("SSDAEFLG", 3, 1));
					break;
				}
				break;
			}
		}
	}
	LogExit("Common - Scripts - Common.js - ReadROFlag");
	return value;
}


/**
*
* Base64 encode / decode
* Code "Borrowed" from http://www.webtoolkit.info/javascript-base64.html
*
**/
var Base64 = {
	// private property
	_keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

	// public method for encoding
	encode : function (input) {
		LogEntry("Common - Scripts - Common.js - encode");
		var output = "";
		var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
		var i = 0;

		input = Base64._utf8_encode(input);

		while (i < input.length)
		{
			chr1 = input.charCodeAt(i++);
			chr2 = input.charCodeAt(i++);
			chr3 = input.charCodeAt(i++);

			enc1 = chr1 >> 2;
			enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
			enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
			enc4 = chr3 & 63;

			if (isNaN(chr2)) {
				enc3 = enc4 = 64;
			}
			else if (isNaN(chr3))
			{
				enc4 = 64;
			}

			output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2)
			                + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
		}
		LogExit("Common - Scripts - Common.js - encode");
		return output;
	},

	// public method for decoding
	decode : function (input) 
	{
		LogEntry("Common - Scripts - Common.js - decode");
		var output = "";
		var chr1, chr2, chr3;
		var enc1, enc2, enc3, enc4;
		var i = 0;

		input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

		while (i < input.length) 
		{
			enc1 = this._keyStr.indexOf(input.charAt(i++));
			enc2 = this._keyStr.indexOf(input.charAt(i++));
			enc3 = this._keyStr.indexOf(input.charAt(i++));
			enc4 = this._keyStr.indexOf(input.charAt(i++));

			chr1 = (enc1 << 2) | (enc2 >> 4);
			chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
			chr3 = ((enc3 & 3) << 6) | enc4;

			output = output + String.fromCharCode(chr1);

			if (enc3 != 64) 
			{
				output = output + String.fromCharCode(chr2);
			}
			if (enc4 != 64) 
			{
				output = output + String.fromCharCode(chr3);
			}
		}
		output = Base64._utf8_decode(output);
		LogExit("Common - Scripts - Common.js - decode");
		return output;
	},

	// private method for UTF-8 encoding
	_utf8_encode : function (encodeString)
	{
		LogEntry("Common - Scripts - Common.js - _utf8_encode");
		encodeString = encodeString.replace(/\r\n/g,"\n");
		var utftext = "";
		for (var n = 0; n < encodeString.length; n++) 
		{
			var c = encodeString.charCodeAt(n);
			if (c < 128) 
			{
				utftext += String.fromCharCode(c);
			}
			else if((c > 127) && (c < 2048)) 
			{
				utftext += String.fromCharCode((c >> 6) | 192);
				utftext += String.fromCharCode((c & 63) | 128);
			}
			else 
			{
				utftext += String.fromCharCode((c >> 12) | 224);
				utftext += String.fromCharCode(((c >> 6) & 63) | 128);
				utftext += String.fromCharCode((c & 63) | 128);
			}
		}
		LogExit("Common - Scripts - Common.js - _utf8_encode");
		return utftext;
	},

	// private method for UTF-8 decoding
	_utf8_decode : function (utftext) 
	{
		LogEntry("Common - Scripts - Common.js - _utf8_decode");
		var tmpString = "";
		var i = 0;
		var c = c1 = c2 = 0;

		while ( i < utftext.length ) 
		{
			c = utftext.charCodeAt(i);

			if (c < 128) 
			{
				tmpString += String.fromCharCode(c);
				i++;
			}
			else if((c > 191) && (c < 224)) 
			{
				c2 = utftext.charCodeAt(i+1);
				tmpString += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
				i += 2;
			}
			else 
			{
				c2 = utftext.charCodeAt(i+1);
				c3 = utftext.charCodeAt(i+2);
				tmpString += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
				i += 3;
			}
		}
		LogExit("Common - Scripts - Common.js - _utf8_decode");
		return tmpString;
	}
} // End Base64 class

function isArray(obj)
{
	LogEntry("Common - Scripts - Common.js - isArray");
	var Result = false;
	if (obj.constructor.toString().indexOf("Array") != -1)
		Result = true
	
	LogExit("Common - Scripts - Common.js - isArray");
	return Result;
}

//---------------------------------------------------
// GetMinPwdLen
//---------------------------------------------------
function GetMinPwdLen()
{
	LogEntry("Common - Scripts - Common.js - GetMinPwdLen");
	var nMinPwdLen = 4;
	try
	{
		nMinPwdLen = getMXISDK().Config.PwdRule(SSD_PWDRULE_TYPE_MINPWDLEN);
	}
	catch(err)
	{
		LogInfo(err.description);
	}
	LogExit("Common - Scripts - Common.js - GetMinPwdLen");
	return nMinPwdLen;
}

//<!--##################################-->
function GetDeviceTypeName(devType)
{
	LogEntry("Common - Scripts - Common.js - GetDeviceTypeName");
	var DeviceName = "";
	switch (devType)
	{
		case SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_MXP:
			DeviceName = Str_DevName_Stealth;
			break;
		case SSD_DEVICE_TYPE_CLIPDRIVE_OUTBACKER_MXP:
			DeviceName = Str_DevName_Outbacker;
			break;
		case SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_BIO_TOKEN:
			DeviceName = Str_DevName_BioToken;
			break;
		case SSD_DEVICE_TYPE_CLIPDRIVE:
			DeviceName = Str_DevName_ClipDrive;
			break;
		case SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_TOKEN:
			DeviceName = Str_DevName_Token;
			break;
		case SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_PASSPORT:
			DeviceName = Str_DevName_Passport;
			break;
		case SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_MINI:
			DeviceName = Str_DevName_Mini;
			break;
		default:
			DeviceName = "";
			break;
//		case SSD_DEVICE_TYPE_CLIPDRIVE_BIO:
//			DeviceName = ;
//			break;
//		case SSD_DEVICE_TYPE_CLIPDRIVE_BIO_IDENT:
//			DeviceName = ;
//			break;
//		case SSD_DEVICE_TYPE_CLIPDRIVE_OUTBACKER_MICRO:
//			DeviceName = ;
//			break;
//		case SSD_DEVICE_TYPE_CLIPDRIVE_OUTBACKER:
//			DeviceName = ;
//			break;
//		case SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH:
//			DeviceName = ;
//			break;
//		case SSD_DEVICE_TYPE_CLIPDRIVE_IDENT:
//			DeviceName = ;
//			break;
	}
	LogExit("Common - Scripts - Common.js - GetDeviceTypeName");
	return DeviceName;
}

//<!--##################################-->
function GetDeviceType()
{
	LogEntry("Common - Scripts - Common.js - GetDeviceType");
	var KindID = getMXISDK().Config.KindID;
	if (KindID == SSD_DEVICE_TYPE_CLIPDRIVE_BIO || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_BIO_IDENT || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_OUTBACKER_MICRO || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_MXP || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_OUTBACKER_MXP || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_BIO_TOKEN)
		InsertValue("DeviceType", "Biometric");
	else if (KindID == SSD_DEVICE_TYPE_CLIPDRIVE || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_OUTBACKER || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_IDENT || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_TOKEN || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_PASSPORT || KindID == SSD_DEVICE_TYPE_CLIPDRIVE_STEALTH_MINI)
		InsertValue("DeviceType", "Password");
	else
		ShowWarning(GetErrorMsg(SSD_SCRIPT_WARN_UNKNOWN_DEVICE, ""));
	
	LogExit("Common - Scripts - Common.js - GetDeviceType");
	return;
}

//<!--##################################-->
function InsertValue( ValueName, newValue )
{
	LogEntry("Common - Scripts - Common.js - InsertValue");
	var num = 1;
	var CurValueName = getMXISession().GetValue("Desc" + num);
	while (CurValueName != null && CurValueName != "")
	{
		if (CurValueName.length = ValueName.length && CurValueName.indexOf(ValueName) != -1) 
		{
			getMXISession().SetValue("Value" + num, newValue);
			LogExit("Common - Scripts - Common.js - InsertValue");
			return;
		}
		num = num + 1;
		CurValueName = getMXISession().GetValue( "Desc" + num );
	}
	AddValue(num, ValueName, newValue);
	LogExit("Common - Scripts - Common.js - InsertValue");
	return;
}

//<!--##################################-->
function AddValue( ItemNum, Desc, Value )
{
	LogEntry("Common - Scripts - Common.js - AddValue");
	getMXISession().SetValue("Desc" + ItemNum, Desc);
	getMXISession().SetValue("Value" + ItemNum, Value);
	ItemNum = ItemNum + 1;
	LogExit("Common - Scripts - Common.js - AddValue");
	return;
}

//<!--##################################-->
function showBubbleToolTip(text){
	var tmpWindow = curWindow()
	var obj    = tmpWindow.document.getElementById('bubble_tooltip');
	var obj2   = tmpWindow.document.getElementById('bubble_tooltip_content');
	
	//Change the tip's text
	InnerText(obj2, text);
	
	//Turn on display
	obj.style.display = "block";
	
	//Make sure the tooltip is on top
	obj.style.zIndex = 9999;

	//the tooltip will appear just under the carret's position
	var caretPos = document.selection.createRange();
	var TopPos = caretPos.boundingTop;
	var LeftPos = caretPos.boundingLeft;
	TopPos = TopPos + 16;
	LeftPos = LeftPos - 44;	
	obj.style.top  = TopPos;
	obj.style.left = LeftPos;
}	

//<!--##################################-->
function hideBubbleToolTip()
{
	curWindow().document.getElementById("bubble_tooltip").style.display = "none";
}

// Caps Lock monitoring methods.
// To be used as follow:
// 
// 1) Add those two lines in the Load function in order to divert the polling from the MXISDK_StateChanged to the
//    SpeechBubbleTimerFunc. The newly polling method SpeechBubbleTimerFunc will call, after it is done its checks, the
//    MXISDK_StateChanged function.
//       window.clearInterval(PollingTimer);
//       LocalTimer = window.setInterval("SpeechBubbleTimerFunc()", 1000);
// 
// 2) Add the following HTML object just inside the body tag so it is readily available for use by the handling
//    functions.
//       <div id="bubble_tooltip">
//          <div class="bubble_top"><span></span></div>
//          <div class="bubble_middle"><span id="bubble_tooltip_content"></span></div>
//          <div class="bubble_bottom"></div>
//       </div>
// 
// 3) In the Password field you want to be monitored, add the folowing event handlers:
//    - onfocus="PWD_OnCarretEnter(event)"
//    - onkeypress="PWD_OnKeyPress(event)"

var hideBubbleTimeout = -1;
var showBubbleTimeout = -1;
var showBubbleOnKeyPress = true;
//<!--##################################-->
function PWD_OnKeyDown(oEvent)
{
	LogEntry("Common - Common.js - PWD_OnKeyDown");
	// Netscape                  // IE                     // Gecko
	if ( (oEvent.which == 20) || (oEvent.keyCode == 20) || (oEvent.charCode == 20) )
	{
		if (getMXIBrowser().CapsLockOn)
		{
			showBubbleTimeout = 0;
		}
	}

	LogExit("Common - Common.js - PWD_OnKeyDown");
	return;
}

//<!--##################################-->
function PWD_OnKeyPress(oEvent)
{
	LogEntry("Common - Common.js - PWD_OnKeyPress");
	// Netscape                  // IE                     // Gecko
	if ( (oEvent.which == 13) || (oEvent.keyCode == 13) || (oEvent.charCode == 13) )
	{
		NextBtn_onClick();
	}
	else
	{
		if (getMXIBrowser().CapsLockOn && showBubbleOnKeyPress)
		{
			showBubbleTimeout = 0;
			showBubbleOnKeyPress = false;
		}
	}
	LogExit("Common - Common.js - PWD_OnKeyPress");
	return;
}
//Called when the user clicks on / tabs to the password field (OnFocus)
function PWD_OnCarretEnter()
{
	LogEntry("Common - Common.js - PWD_OnCarretEnter");
	
	if (getMXIBrowser().CapsLockOn)
	{
		showBubbleTimeout = 0;
	}
	Refresh();

	LogExit("Common - Common.js - PWD_OnCarretEnter");
	return;
}

//<!--##################################-->
// Using the state chage interval to detect that we need to hide the password speech bubble pop up.
function SpeechBubbleTimerFunc()
{
	LogEntry("Common - Common.js - SpeechBubbleTimerFunc");
	// Wait 'hideBubbleTimeout' seconds before it hides the speech bubble
	if ( hideBubbleTimeout == 0 )
	{
		hideBubbleToolTip();
	}
	
	if ( hideBubbleTimeout >= 0 )
	{
		hideBubbleTimeout = hideBubbleTimeout - 1;
	}

	// Wait 'showBubbleTimeout' seconds before it shows the speech bubble
	if ( showBubbleTimeout == 0 )
	{
		if (getMXIBrowser().CapsLockOn)
		{
			showBubbleToolTip("Caps Lock is On.\nHaving Caps Lock on may cause you to enter your password incorrectly.\n\nYou should press Caps Lock to turn it off before entering your password.");
		}
		// display the speech bubble for a three seconds interval.
		hideBubbleTimeout = 3;
	}
	if ( showBubbleTimeout >= 0 )
	{
		showBubbleTimeout = showBubbleTimeout - 1;
	}
	// We stole the timer in order to always get notified, give it back the notification before going away.
	MXISDK_StateChanged();
	LogExit("Common - Common.js - SpeechBubbleTimerFunc");
	return;
}
	
	
function TranslateRSAErrorNumber(errornumber, lastError)
{
   var errMsg;
   var errorNumCopy = errornumber;
   
   if (errornumber != SSD_RET_HTML_INTERNAL)
	{
		if (errornumber < 0x0)
			errornumber &= 0x0000FFFF;
	}
	
	switch(errornumber)
	{
		case RSA_NOERROR:
			errMsg = Str_Gen_Success;
			break;
      case ERR_RSANOLICENSE:
			errMsg = Str_No_RSA_Licenses;
			break;
		case ERR_RSAPASSNOTGENERATED:
			errMsg = Str_RSA_PassNotGenerated;
			break;
		case ERR_RSACONNECTIONERROR:
		   errMsg = Str_RSA_ConnectionError;
		break;
		case ERR_RSAOUTOFMEMORY:
			errMsg = Str_RSA_OutOfMemory;
			break;
		case ERR_RSATOKENLISTNOTCREATED:
			errMsg = Str_RSA_TokenListNotCreated;
			break;
		case ERR_RSAFILESYSTEMERROR:
			errMsg = Str_RSA_FileSystemError;
			break;
		case ERR_RSACANTRECOGNIZEDEVICE:
			errMsg = Str_RSA_CantRecognizeDevice;
			break;
		case ERR_RSABASE64DECODING:
		   errMsg = Str_RSA_Base64Decoding;
		   break;
	   case ERR_RSATOKENEMPTY:
	      errMsg = Str_RSATOKENEMPTY;
	      break;
		
		case ERR_RSA_CONFIG_USERALREADYPRESENT:
		   errMsg = Str_RSA_CONFIG_USERALREADYPRESENT;
		   break;
		
		case ERR_RSA_CONFIG_SOFTTOKENPRESENT:
		   errMsg = Str_RSA_CONFIG_SOFTTOKENPRESENT;
		   break;
		   
		case ERR_RSA_CONFIG_USERNOTPRESENT:
		   errMsg = Str_RSA_CONFIG_USERNOTPRESENT;
		   break;
		   
		case ERR_RSAINJECT:
		   errMsg = Str_RSAInjectError;
		   break;
		
		case ERR_RSAIMPORT:
		   errMsg = Str_RSAImportError;
		   break;
		case ERR_RSASYSERROR:
			errMsg = lastError;
			break;
	
		default:
         errMsg = Str_RSA_Unknown_Error + " " + String(errorNumCopy);
         break;
      }   
   return (errMsg);
}

function TranslateWEBCREDErrorNumber(errornumber, lastError)
{
   var errMsg;
   var errorNumCopy = errornumber;
   if (errornumber != SSD_RET_HTML_INTERNAL)
	{
		if (errornumber < 0x0)
			errornumber &= 0x0000FFFF;
	}
	switch(errornumber)
	{
		case WEBCRED_NOERROR:
			errMsg = Str_Gen_Success;
			break;
      case ERR_WEBCREDNOLICENSE:
			errMsg = Str_No_WEBCRED_Licenses;
			break;  
		case ERR_WEBCREDOUTOFMEMORY:
			errMsg = Str_WEBCRED_OutOfMemory;
			break; 
		case ERR_WEBCREDFILESYSTEMERROR:
			errMsg = Str_WEBCRED_FileSystemError;
			break;
		case ERR_WEBCREDCANTRECOGNIZEDEVICE:
			errMsg = Str_WEBCRED_CantRecognizeDevice;
			break;
		case ERR_WEBCREDBASE64DECODING:
		   errMsg = Str_WEBCRED_Base64Decoding;
		   break;
			
		case ERR_WEBCREDSYSERROR:
			errMsg = lastError;
			break;
			
		default:
         errMsg = Str_WEBCRED_Unknown_Error + " " + String(errorNumCopy);
         break;
      }   
   return (errMsg);
}

function IsAEFeaturePresent(Feature)
{
	LogEntry("Common - Scripts - Common.js - IsAEFeaturePresent");
	var Result = false;
	var szDirectory = GetBaseDirectory();
	switch (Feature)
	{
		case FEATURE_INITIALIZATION:
			szDirectory = szDirectory + "/Initialization/Default.htm";
			break;
		case FEATURE_ISSUANCE:
			szDirectory = szDirectory + "/Issuance/Default.htm";
			break;
		case FEATURE_HELPDESK:
			szDirectory = szDirectory + "/HelpDesk/Rescue.htm";
			break;
		case FEATURE_DATARECOVERY:
			szDirectory = szDirectory + "/DataRecovery/Recover.htm";
			break;
		case FEATURE_PERSONALIZATION:
			szDirectory = szDirectory + "/Personalization/Default.htm";
			break;
		case FEATURE_LICENSE:
			szDirectory = szDirectory + "/License/License.htm";
			break;
		case FEATURE_STATS:
			szDirectory = szDirectory + "/Stats/Stats.htm";
			break;
		case FEATURE_INFO:
			szDirectory = szDirectory + "/Info/DevInfo.htm";
			break;
	}
	var FS = getMXIBrowser().CreateObject("Scripting.FileSystemObject");
	Result = FS.FileExists(szDirectory);
	LogExit("Common - Scripts - Common.js - IsAEFeaturePresent");
	return Result;
}

//---------------------------------------------------
// GetDefaultUserPassword
//---------------------------------------------------
function GetLDAPType()
{
	LogEntry("Common - Scripts - Common.js - GetDirectoryType");
	LogExit("Common - Scripts - Common.js - GetDirectoryType");
	switch(getMXIUtil().ReadConfigValue("./Config/Presenter.ini", "LDAP", "SAMAccountName", ""))
	{
	case "sAMAccountName":
		return SSD_DIRTYPE_ACTIVEDIRECTORY;
	case "sn":
		return SSD_DIRTYPE_ADAM;
	default:
		return -1;
	}
}

function LookUpLicenseAppName(AppID, DefaultName)
{
	LogEntry("Common - Scripts - Common.js - LookUpLicenseAppName");
	var szAppName = "";	
	switch(AppID)
	{
		case "0":
			szAppName = Str_License_AppName_Cert;
			
		case "1":
			szAppName = Str_License_AppName_RSA;
			
		default:
			szAppName = DefaultName;
	}
	LogExit("Common - Scripts - Common.js - LookUpLicenseAppName");
	return szAppName;
}

//---------------------------------------------------
// Load the help screen
//---------------------------------------------------
function HelpWindow()
{
	LogEntry("Common - Scripts - Common.js - HelpWindow");
	
	getMXISession().SetValue("PageTitle", curWindow().document.getElementById('PageTitle').innerText);
	getMXISession().SetValue("FrameInfo", curWindow().document.getElementById('HelpString').innerHTML);
	var HREF = GetHelpFile();
	ModalWindow(HREF, SSD_HELP_WINDOW_WIDTH, SSD_HELP_WINDOW_HEIGHT, false);
	
	LogExit("Common - Scripts - Common.js - HelpWindow");
}